% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/black_figures.R
\name{biscuit}
\alias{biscuit}
\alias{s_biscuit}
\title{Coordinates of a biscuit}
\usage{
biscuit(size.x = 10, size.y = size.x, shd = "black", lwd = 3, lty = 0)

s_biscuit(
  pos.x = 0,
  pos.y = 0,
  size.x = 10,
  size.y = size.x,
  shd = "black",
  lty = 1,
  lwd = 3
)
}
\arguments{
\item{size.x}{numeric, define the semi-major axis of the ellipse within which the figure is inscribed. Default is 10}

\item{size.y}{numeric, define the semi-minor axis of the ellipse within which the figure is inscribed. Default is size.x}

\item{shd}{character, define the shading of the figure. Default is black}

\item{lwd}{integer, define the line width of the figure. Default is 3}

\item{lty}{integer, define the line type of the figure, default is 0}

\item{pos.x}{numeric, position on the x axis. Default is 0}

\item{pos.y}{numeric, position the y axis, Default is 0}
}
\value{
Return the coordinates for drawing a biscuit

Return the coordinates for drawing a single biscuit
}
\description{
Define the coordinates for drawing a biscuit (composed of two hexagons)
}
\section{Functions}{
\itemize{
\item \code{s_biscuit()}: Coordinates of a single biscuit

Define the coordinates for drawing a single biscuit (composed of two hexagons), to be used in shape()

}}
\examples{
# return the default coordinates for drawing a biscuit
biscuit()
# change the shade of the biscuit
biscuit(shd = "grey", lty = 0)
# return the default coordinates for drawing a single biscuit
s_biscuit()
# change the shade of the single biscuit
biscuit(shd = "grey", lty = 0)
}
