% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markov_mix_utils.R
\name{get_prob}
\alias{get_prob}
\title{Get probability matrix from MarkovFit object}
\usage{
get_prob(object, check = TRUE)
}
\arguments{
\item{object}{\code{\link{MarkovMix}} object.}

\item{check}{Logical (1L) indicating whether to check \code{object}
at the beginning.}
}
\value{
A numeric matrix indicating probabilities of each state transition pattern in each component.
}
\description{
\code{get_prob} gets probability matrix from \code{\link{MarkovMix}} object.
It normalizes each column in the count matrix to sum up to 1.
}
\note{
Change log:
\itemize{
\item{0.1.0 Xiurui Zhu - Initiate the class.}
}
}
\examples{
# Load example MarkovMix object
data("markov_mix_ex")

# Derive state transition patterns
get_states_mat(markov_mix_ex)

# Derive probability matrices
get_prob(markov_mix_ex)

# Derive component priors
get_prior(markov_mix_ex)

# Combine state transition patterns and their probabilities
cbind(
  as.data.frame(get_states_mat(markov_mix_ex)),
  as.data.frame(get_prob(markov_mix_ex))
)
}
\seealso{
Other MarkovMix utilities: 
\code{\link{get_prior}()},
\code{\link{get_states_mat}()},
\code{\link{restate}()}
}
\author{
Xiurui Zhu
}
\concept{MarkovMix utilities}
