% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_model.R, R/market_fit.R
\name{market_aggregation}
\alias{market_aggregation}
\alias{aggregate_demand}
\alias{aggregate_demand,missing,market_model,ANY-method}
\alias{aggregate_supply}
\alias{aggregate_supply,missing,market_model,ANY-method}
\alias{aggregate_demand,market_fit,missing,missing-method}
\alias{aggregate_supply,market_fit,missing,missing-method}
\title{Market side aggregation.}
\usage{
aggregate_demand(fit, model, parameters)

\S4method{aggregate_demand}{missing,market_model,ANY}(model, parameters)

aggregate_supply(fit, model, parameters)

\S4method{aggregate_supply}{missing,market_model,ANY}(model, parameters)

\S4method{aggregate_demand}{market_fit,missing,missing}(fit)

\S4method{aggregate_supply}{market_fit,missing,missing}(fit)
}
\arguments{
\item{fit}{A fitted market model object.}

\item{model}{A model object.}

\item{parameters}{A vector of model's parameters.}
}
\value{
The sum of the estimated demanded or supplied quantities evaluated at the
given parameters.
}
\description{
Market side aggregation.
}
\details{
Calculates the sample's aggregate demand or supply using the
estimated coefficients of a fitted model. Alternatively, the function
calculates aggregates using a model and a set of parameters passed
separately. If the model's data have multiple distinct subjects at each
date, aggregation is calculated over subjects per unique date. If the model
has time series data, namely a single subject per time point, aggregation
is ululated over all time pints.
}
\section{Functions}{
\itemize{
\item \code{aggregate_demand}: Demand aggregation.

\item \code{aggregate_supply}: Supply aggregation.
}}

\examples{
\donttest{
fit <- diseq_basic(
  HS | RM | ID | TREND ~
    RM + TREND + W + CSHS + L1RM + L2RM + MONTH |
      RM + TREND + W + L1RM + MA6DSF + MA3DHF + MONTH,
  fair_houses(),
  correlated_shocks = FALSE
)

# get estimated aggregate demand
aggregate_demand(fit)

# simulate the deterministic adjustment model
model <- simulate_model(
  "diseq_deterministic_adjustment", list(
    # observed entities, observed time points
    nobs = 500, tobs = 3,
    # demand coefficients
    alpha_d = -0.6, beta_d0 = 9.8, beta_d = c(0.3, -0.2), eta_d = c(0.6, -0.1),
    # supply coefficients
    alpha_s = 0.2, beta_s0 = 4.1, beta_s = c(0.9), eta_s = c(-0.5, 0.2),
    # price equation coefficients
    gamma = 0.9
  ),
  seed = 1356
)

# estimate the model object
fit <- estimate(model)

# get estimated aggregate demand
aggregate_demand(fit)

# get estimated aggregate demand
aggregate_supply(fit)
}
}
\seealso{
\code{\link{demanded_quantities}}, \code{\link{supplied_quantities}}
}
