% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.real.R
\name{compute.real}
\alias{compute.real}
\title{Compute estimates of real parameters}
\usage{
compute.real(model, parameter, ddl = NULL, dml = NULL, unique = TRUE,
  vcv = FALSE, se = FALSE, chat = 1, subset = NULL, select = NULL,
  showDesign = FALSE, include = NULL, uselink = FALSE)
}
\arguments{
\item{model}{model object}

\item{parameter}{name of real parameter to be computed (eg "Phi" or "p")}

\item{ddl}{list of design data}

\item{dml}{design matrix list}

\item{unique}{TRUE if only unique values should be returned}

\item{vcv}{logical; if TRUE, computes and returns v-c matrix of real estimates}

\item{se}{logical; if TRUE, computes std errors and conf itervals of real estimates}

\item{chat}{over-dispersion value}

\item{subset}{logical expression using fields in real dataframe}

\item{select}{character vector of field names in real that you want to include}

\item{showDesign}{if TRUE, show design matrix instead of data}

\item{include}{vector of field names always to be included even when select or unique specified}

\item{uselink}{default FALSE; if TRUE uses link values in evaluating uniqueness}
}
\value{
A data frame (\code{real}) is returned if \code{vcv=FALSE};
otherwise, a list is returned also containing vcv.real: \item{real}{ data
frame containing estimates, and if vcv=TRUE it also contains
standard errors and confidence intervals} \item{vcv.real}{variance-covariance matrix of
real estimates}
}
\description{
Computes real estimates and their var-cov for a particular parameter.
}
\details{
This code is complicated because it handles both the MCMC models and the likelihood models. The former is quite 
simple than the latter because all of the real computation is done by the model code and this function only computes 
summaries.  The likelihood model code is complicated primarily by the mlogit parameters which are computed in 2 stages:
1) log link and 2) summation to normalize. The mlogit is handled differently depending on the model.
For MS and JS models, one of the parameters is computed by subtraction (specified as addone==TRUE) whereas the
HMM models (addone=FALSE) specify a parameter for each cell and one is fixed by the user to 1. The latter is preferable
because it then provides an estimate and a std error for each parameter whereas the subtracted value is not provided for MS and JS.

This function differs from compute.real in RMark because it only computes the values for a single parameter whereas the function 
with the same name in RMark can compute estimates from multiple parameters (eg Phi and p).
}
\examples{
data(dipper)
dipper.proc=process.data(dipper,model="cjs",begin.time=1)
dipper.ddl=make.design.data(dipper.proc)
mod.Phisex.pdot=crm(dipper.proc,dipper.ddl,
 model.parameters=list(Phi=list(formula=~sex+time),p=list(formula=~1)),hessian=TRUE)
xx=compute.real(mod.Phisex.pdot,"Phi",unique=TRUE,vcv=TRUE)
}
\author{
Jeff Laake
}
\keyword{utility}
