% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mat.polyn.R
\name{rand.shock}
\alias{rand.shock}
\title{rand.shock}
\usage{
rand.shock(ar.poly, ma.poly, L)
}
\arguments{
\item{ar.poly}{autoregressive matrix part of model}

\item{ma.poly}{moving average matrix part of model}

\item{L}{order of return polynomial  (length=L+1 including
leading unity matrix)}
}
\value{
random shock form of arma model up to order L (array(k,k,L+1))
}
\description{
Calculation of random shock form for arma model
}
\examples{
set.seed(4711)
p1  <- check.one(matrix(rnorm(16),nrow=4))
p2  <- check.one(array(rnorm(32),dim=c(4,4,2)))
randshock <- rand.shock(ar.poly=p1,ma.poly=p2,L=6)
short.form(randshock)
}

