% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datagrid.R
\name{datagridcf}
\alias{datagridcf}
\title{A "counterfactual" version of the \code{datagrid()} function.}
\usage{
datagridcf(..., model = NULL, newdata = NULL)
}
\arguments{
\item{...}{named arguments with vectors of values or functions for user-specified variables.
\itemize{
\item Functions are applied to the variable in the \code{model} dataset or \code{newdata}, and must return a vector of the appropriate type.
\item Character vectors are automatically transformed to factors if necessary.
+The output will include all combinations of these variables (see Examples below.)
}}

\item{model}{Model object}

\item{newdata}{data.frame (one and only one of the \code{model} and \code{newdata} arguments}
}
\description{
For each combination of the variable values specified, this function
duplicates the entire data frame supplied to \code{newdata}, or the entire
dataset used to fit \code{model}. This is a convenience shortcut to call the
\code{datagrid()} function with argument \code{grid_type="counterfactual"}.
}
\examples{
# Fit a model with 32 observations from the `mtcars` dataset.
nrow(mtcars)

mod <- lm(mpg ~ hp + am, data = mtcars)

# We specify two values for the `am` variable and obtain a counterfactual
# dataset with 64 observations (32 x 2).
dat <- datagridcf(model = mod, am = 0:1)
head(dat)
nrow(dat)

# We specify 2 values for the `am` variable and 3 values for the `hp` variable
# and obtained a dataset with 192 observations (2x3x32), corresponding to the
# full original data, with each possible combination of `hp` and `am`.
dat <- datagridcf(am = 0:1, hp = c(100, 110, 120), newdata = mtcars)
head(dat)
dim(dat)

}
