% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_vcov.R, R/methods_MASS.R, R/methods_aod.R,
%   R/methods_nnet.R, R/methods_crch.R, R/methods_sampleSelection.R,
%   R/methods_scam.R
\name{get_vcov}
\alias{get_vcov}
\alias{get_vcov.default}
\alias{get_vcov.polr}
\alias{get_vcov.glimML}
\alias{get_vcov.multinom}
\alias{get_vcov.crch}
\alias{get_vcov.selection}
\alias{get_vcov.scam}
\title{Get a named variance-covariance matrix from a model object (internal function)}
\usage{
get_vcov(model, ...)

\method{get_vcov}{default}(model, ...)

\method{get_vcov}{polr}(model, ...)

\method{get_vcov}{glimML}(model, ...)

\method{get_vcov}{multinom}(model, ...)

\method{get_vcov}{crch}(model, ...)

\method{get_vcov}{selection}(model, ...)

\method{get_vcov}{scam}(model, ...)
}
\arguments{
\item{model}{Model object}

\item{...}{Additional arguments are passed to the \code{predict()} method used to
compute adjusted predictions. These arguments are particularly useful for
mixed-effects or bayesian models (see the online vignettes on the
\code{marginaleffects} website). Available arguments can vary from model to
model, depending on the range of supported arguments by each modeling
package. See the "Model-Specific Arguments" section of the
\code{?marginaleffects} document for a non-exhaustive list of available
arguments.}
}
\value{
A named square matrix of variance and covariances. The names must match the coefficient names.
}
\description{
Get a named variance-covariance matrix from a model object (internal function)
}
\keyword{internal}
