% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dydx_and_se.R
\name{get_dydx_and_se}
\alias{get_dydx_and_se}
\alias{get_dydx_and_se.default}
\title{Get marginal effects and standard errors (internal function)}
\usage{
get_dydx_and_se(model, ...)

\method{get_dydx_and_se}{default}(
  model,
  variables,
  fitfram = insight::get_data(model),
  vcov = stats::vcov(model),
  group_name = NULL,
  type = "response",
  numDeriv_method = "simple",
  ...
)
}
\arguments{
\item{model}{Model object}

\item{...}{Additional arguments are pushed forward to \code{predict()}.}

\item{variables}{Variables to consider (character vector). \code{NULL}
calculates marginal effects for all terms in the model object.}

\item{fitfram}{A data.frame over which to compute marginal effects.}

\item{vcov}{Matrix or boolean
\itemize{
\item FALSE: does not compute unit-level standard errors.
\item TRUE: computes unit-level standard errors using the default \code{vcov(model)} variance-covariance matrix.
\item Named square matrix: computes standard errors with a user-supplied variance-covariance matrix. This matrix must be square and have dimensions equal to the number of coefficients in \code{get_coef(model)}.
}}

\item{group_name}{String to identify the "group" or "level" of the terms to
estimate. Groups are often used in models like multinomial logit where each
level of the response variable is associated to its own set of coefficients.}

\item{type}{Type(s) of prediction as string or vector This can
differ based on the model type, but will typically be a string such as:
"response", "link", "probs", or "zero".}

\item{variable}{A string to identify the variable whose marginal effect to compute.}
}
\value{
A data.frame with term names, group names, marginal effects, and
standard errors.
}
\description{
Get marginal effects and standard errors (internal function)
}
\keyword{internal}
