% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tiles.R
\name{plot_tiles}
\alias{plot_tiles}
\title{Plot map tiles}
\usage{
plot_tiles(x, add = FALSE, ...)
}
\arguments{
\item{x}{a SpatRaster object.}

\item{add}{whether to add the layer to an existing plot (TRUE) or
not (FALSE).}

\item{...}{bgalpha, interpolate, or other arguments passed to be passed to
\code{\link[terra:plotRGB]{plotRGB}}}
}
\description{
Plot a SpatRaster object over a map. It can be used to plot tiles.
}
\note{
This function is a wrapper for \code{\link[terra:plotRGB]{plotRGB}}
from the terra package.
}
\examples{
library(sf)
library(maptiles)
nc <- st_read(system.file("shape/nc.shp", package="sf"), quiet = TRUE)
nc_osm <- get_tiles(nc, crop = TRUE)
plot_tiles(nc_osm)
}
