% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_treecover_area.R
\name{treecover_area}
\alias{treecover_area}
\alias{calc_treecover_area}
\title{Calculate treecover statistics}
\usage{
calc_treecover_area(years = 2000:2023, min_size = 10, min_cover = 35)
}
\arguments{
\item{years}{A numeric vector with the years for which to calculate treecover
area.}

\item{min_size}{The minimum size of a forest patch to be considered as forest in ha.}

\item{min_cover}{The minimum cover percentage per pixel to be considered as forest.}
}
\value{
A function that returns a tibble with a column for years and
treecover (in ha).
}
\description{
This functions allows to efficiently calculate treecover statistics for
polygons. For each year in the analysis timeframe, the forest losses in
preceding and the current years are subtracted from the treecover in the
year 2000 and actual treecover figures within the polygon are returned.
}
\details{
The required resources for this indicator are:
\itemize{
\item \link{gfw_treecover}
\item \link{gfw_lossyear}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  get_resources(
    get_gfw_treecover(version = "GFC-2023-v1.11"),
    get_gfw_lossyear(version = "GFC-2023-v1.11")
  ) \%>\%
  calc_indicators(calc_treecover_area(years = 2016:2017, min_size = 1, min_cover = 30)) \%>\%
  portfolio_long()

aoi
}
}
\keyword{indicator}
