% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_gsw_change.R
\name{gsw_change}
\alias{gsw_change}
\alias{calc_gsw_change}
\title{Calculate Global Surface Water (GSW) Change}
\usage{
calc_gsw_change(engine = "extract", stats = "mean")
}
\arguments{
\item{engine}{The preferred processing functions from either one of "zonal",
"extract" or "exactextract". Default: "extract".}

\item{stats}{Aggregation function with which the data are combined.
Default: "mean".}
}
\value{
A function that returns a tibble with a column for the aggregated
GSW change indicator.
}
\description{
The change in water occurrence intensity between the two periods is derived
from homologous pairs of months (i.e. same months containing valid
observations in both periods). The difference in the occurrence of surface
water was calculated for each homologous pair of months. The average of all
of these differences constitutes the Surface Water Occurrence change
intensity. The raster files have integer cell values between \verb{[0, 200]}
where 0 represents surface water loss and 200 represents surface water gain.
}
\details{
The pixel values are aggregated using method provided via the
\code{stats} parameter using the specified \code{engine}.

The required resources for this indicator are:
\itemize{
\item \link{global_surface_water_change}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- system.file("extdata", "shell_beach_protected_area_41057_B.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  get_resources(get_global_surface_water_change()) \%>\%
  calc_indicators(
    calc_gsw_change(engine = "extract", stats = "mean")
  ) \%>\%
  portfolio_long()

aoi
}
}
\keyword{indicator}
