test_that("mangrove extent works", {
  skip_on_os("mac")
  shp <- read_sf(
    system.file("extdata", "shell_beach_protected_area_41057_B.gpkg",
      package = "mapme.biodiversity"
    )
  )
  shp <- st_make_valid(shp)
  source <- list.files(system.file("res", "mangrove",
    package = "mapme.biodiversity"
  ), pattern = ".gpkg$", full.names = TRUE)
  mangrove <- lapply(1:length(source), function(j) {
    out <- read_sf(source[[j]])
    out <- st_make_valid(out)
  })
  names(mangrove) <- basename(source)
  attributes(shp)$cores <- 1
  expect_snapshot(
    .calc_gmw(shp, mangrove)
  )
})
