% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{add_fill_extrusion_layer}
\alias{add_fill_extrusion_layer}
\title{Add a fill-extrusion layer to a Mapbox GL map}
\usage{
add_fill_extrusion_layer(
  map,
  id,
  source,
  source_layer = NULL,
  fill_extrusion_base = NULL,
  fill_extrusion_color = NULL,
  fill_extrusion_height = NULL,
  fill_extrusion_opacity = NULL,
  fill_extrusion_pattern = NULL,
  fill_extrusion_translate = NULL,
  fill_extrusion_translate_anchor = "map",
  visibility = "visible",
  slot = NULL,
  min_zoom = NULL,
  max_zoom = NULL,
  popup = NULL,
  tooltip = NULL,
  hover_options = NULL,
  before_id = NULL
)
}
\arguments{
\item{map}{A map object created by the \code{mapboxgl} function.}

\item{id}{A unique ID for the layer.}

\item{source}{The ID of the source, alternatively an sf object (which will be converted to a GeoJSON source) or a named list that specifies \code{type} and \code{url} for a remote source.}

\item{source_layer}{The source layer (for vector sources).}

\item{fill_extrusion_base}{The base height of the fill extrusion.}

\item{fill_extrusion_color}{The color of the fill extrusion.}

\item{fill_extrusion_height}{The height of the fill extrusion.}

\item{fill_extrusion_opacity}{The opacity of the fill extrusion.}

\item{fill_extrusion_pattern}{Name of image in sprite to use for drawing image fills.}

\item{fill_extrusion_translate}{The geometry's offset. Values are \code{c(x, y)} where negatives indicate left and up.}

\item{fill_extrusion_translate_anchor}{Controls the frame of reference for \code{fill-extrusion-translate}.}

\item{visibility}{Whether this layer is displayed.}

\item{slot}{An optional slot for layer order.}

\item{min_zoom}{The minimum zoom level for the layer.}

\item{max_zoom}{The maximum zoom level for the layer.}

\item{popup}{A column name containing information to display in a popup on click.  Columns containing HTML will be parsed.}

\item{tooltip}{A column name containing information to display in a tooltip on hover. Columns containing HTML will be parsed.}

\item{hover_options}{A named list of options for highlighting features in the layer on hover.}

\item{before_id}{The name of the layer that this layer appears "before", allowing you to insert layers below other layers in your basemap (e.g. labels).}
}
\value{
The modified map object with the new fill-extrusion layer added.
}
\description{
Add a fill-extrusion layer to a Mapbox GL map
}
\examples{
\dontrun{
library(mapgl)

maplibre(
  style = maptiler_style("basic"),
  center = c(-74.0066, 40.7135),
  zoom = 15.5,
  pitch = 45,
  bearing = -17.6
) |>
  add_vector_source(
    id = "openmaptiles",
    url = paste0("https://api.maptiler.com/tiles/v3/tiles.json?key=",
                 Sys.getenv("MAPTILER_API_KEY"))
  ) |>
  add_fill_extrusion_layer(
    id = "3d-buildings",
    source = 'openmaptiles',
    source_layer = 'building',
    fill_extrusion_color = interpolate(
      column = 'render_height',
      values = c(0, 200, 400),
      stops = c('lightgray', 'royalblue', 'lightblue')
    ),
    fill_extrusion_height = list(
      'interpolate',
      list('linear'),
      list('zoom'),
      15,
      0,
      16,
      list('get', 'render_height')
    )
  )
}
}
