% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_helpers.R
\name{match_expr}
\alias{match_expr}
\title{Create a match expression}
\usage{
match_expr(column = NULL, property = NULL, values, stops, default = "#cccccc")
}
\arguments{
\item{column}{The name of the column to use for the match expression. If specified, \code{property} should be NULL.}

\item{property}{The name of the property to use for the match expression. If specified, \code{column} should be NULL.}

\item{values}{A vector of values to match against.}

\item{stops}{A vector of corresponding stops (colors, etc.) for the matched values.}

\item{default}{A default value to use if no matches are found.}
}
\value{
A list representing the match expression.
}
\description{
This function generates a match expression that can be used to style your data.
}
\examples{
match_expr(
  column = "category",
  values = c("A", "B", "C"),
  stops = c("#ff0000", "#00ff00", "#0000ff"),
  default = "#cccccc"
)
}
