% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LPmerge_par.R
\name{LPmerge_par}
\alias{LPmerge_par}
\title{Wrapper for multicore and multichromosome merging of maps using the LPmerge}
\usage{
LPmerge_par(MF.obj, n.cores = 2, max.interval = 1:3, max.int_sel = "auto",
  weights = NULL)
}
\arguments{
\item{MF.obj}{A mapfuser object genetics maps loaded and optionally a reference map}

\item{n.cores}{number of cores}

\item{max.interval}{A whole number specifying the maximum interval size between bins to include in the objective function. An array of numbers can be passed to test different values (one consensus map is produced for each value in the array).}

\item{max.int_sel}{Either automatically select the max.interval with the lowest RMSE for each linkage group or specify manually a vector of values of max.interval to select for the output}

\item{weights}{Optional vector of length T containing the weights for each map in the objective function (see details). If not passed, the maps are given equal weight.}
}
\value{
Three items added to the mapfuser object under the results slot. 1) The consensus map at the selected max.interval, either manually specified or automatically select
2) A list of calculated Root Mean Square Error (RMSE) per chromosome with RMSE for each linkage group ID compared to the consensus map. THe mean and standard deviation over the linkage group IDs is also provided.
3) A list with length equal to the length of the max.interval parameter. Each entry in the list is a data frame containing the consensus map and the component linkage maps.
}
\description{
The LPmerge algorithm is called for all linkage groups with an option for multicore processing. The mapfuser package further adds automatic selection of max.interval giving the lowest RMSE
}
\examples{
\dontshow{
fpath <- system.file("extdata", package="mapfuser")
maps <- list.files(fpath, pattern = "-1", full.names = TRUE)
MF.obj <- read_maps(mapfiles = maps, sep = ",", header = TRUE, type = "delim")
MF.obj <- map_qc(MF.obj)
MF.obj$config$chr <- "1"
MF.obj <- LPmerge_par(MF.obj = MF.obj, n.cores = 1,
max.interval = 1, max.int_sel = "auto", weights = NULL)
}
\dontrun{
MF.obj <- LPmerge_par(MF.obj = MF.obj, n.cores = 2,
max.interval = 1, max.int_sel = "auto", weights = NULL)
# Plot result
plot(MF.obj, which = "single_map", maps = "consensus")
# Access RMSE table
MF.obj$result$RMSE
}
}
\references{
Endelman, JB, and C Plomion. 2014. LPmerge: An R package for merging genetic maps by linear programming. Bioinformatics 30:1623-1624.
}
\author{
Dennis van Muijen
}
