% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrgmod.R
\name{data_helpers}
\alias{data_helpers}
\alias{adm_lines}
\alias{adm_lines.mrgmod}
\alias{obs_lines}
\alias{obs_lines.mrgmod}
\alias{add_covariates}
\alias{add_covariates.mrgmod}
\alias{see_data}
\title{Data helpers}
\usage{
adm_lines(x, ...)

\method{adm_lines}{mrgmod}(x, ...)

obs_lines(x, time, DV, mdv = 0, cmt = NULL, DVmet = NULL, ...)

\method{obs_lines}{mrgmod}(x, time, DV, mdv = NULL, cmt = NULL, DVmet = NULL, ...)

add_covariates(x, covariates, ...)

\method{add_covariates}{mrgmod}(x, ..., covariates = list())

see_data(x, ...)
}
\arguments{
\item{x}{model object}

\item{...}{passed to \code{mrgsolve::ev()} in \code{adm_lines()}}

\item{time, DV, mdv, cmt, DVmet}{passed to \code{obs_lines()}}

\item{covariates}{a list of named covariates, with a single value or same number of lines than data}
}
\value{
a \code{mrgmod} object, with a dataset in the \verb{@args$data} slot.
}
\description{
Helpers to build data set.
}
\details{
Helpful functions build the data set. Instead of painfully build a data set and mind how to format the data, you can pass information about :
\itemize{
\item administrations with \code{adm_lines()},
\item observations with \code{obs_lines()}
\item covariates with \code{add_covariates()}.
}

These functions are passed to a \code{mrgmod} object (mrgsolve model), and return a \code{mrgmod} object with a data set inside with the correct formatting (so-called NM-TRAN format), so that mrgsolve or mapbayr functions can be passed along within a pipe-friendly workflow.

These functions are meant to be used for one single patient at a time. Multiple ID is accepted, but the user is asked to check if the output is acceptable.
}
\examples{
library(magrittr)
# First, import a model
mod <- exmodel(add_exdata = FALSE)

mod \%>\%
  adm_lines(amt = 10000, cmt = 1) \%>\%
  obs_lines(time = c(1.5, 4.4, 7.5, 24.6), DV = c(91.2904, 110.826, 79.384, 20.6671), cmt = 2) \%>\%
  # get_data() # for curiosity, you can extract the data set at this step
  mapbayest()

# If `[ADM]` or `[OBS]` are set in `$CMT` in model code, the `cmt =` argument are superfluous.

}
