% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_comarca.R
\name{esp_get_comarca}
\alias{esp_get_comarca}
\title{Get 'comarcas' of Spain as \CRANpkg{sf} polygons}
\source{
INE: PC_Axis files.
}
\usage{
esp_get_comarca(
  region = NULL,
  comarca = NULL,
  moveCAN = TRUE,
  epsg = "4258",
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE
)
}
\arguments{
\item{region}{A vector of names and/or codes for provinces or \code{NULL} to get
all the comarcas., See \strong{Details}.}

\item{comarca}{A name or \code{\link[base:grep]{regex}} expression with the names of
the required comarcas. \code{NULL} would not produce any filtering.}

\item{moveCAN}{A logical \code{TRUE/FALSE} or a vector of coordinates
\code{c(lat, lon)}. It places the Canary Islands close to Spain's mainland.
Initial position can be adjusted using the vector of coordinates. See
\strong{Displacing the Canary Islands}.}

\item{epsg}{projection of the map: 4-digit \href{https://epsg.io/}{EPSG code}.
One of:
\itemize{
\item \code{"4258"}: ETRS89
\item \code{"4326"}: WGS84
\item \code{"3035"}: ETRS89 / ETRS-LAEA
\item \code{"3857"}: Pseudo-Mercator
}}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source file.}

\item{cache_dir}{A path to a cache directory. See \strong{About caching}.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}
}
\value{
A \CRANpkg{sf} polygon object.
}
\description{
Returns 'comarcas' of Spain as polygons,as provided by the
\strong{INE} (Instituto Nacional de Estadistica).
}
\details{
'Comarcas' (English equivalent: district, county, area or zone) does not
always have a formal legal status. They correspond mainly to natural areas
(valleys, river basins etc.) or even to historical regions or ancient
kingdoms.

When using \code{region} you can use and mix names and NUTS codes
(levels 1, 2 or 3), ISO codes (corresponding to level 2 or 3) or
"cpro" (see \link{esp_codelist}).

When calling a superior level (Province, Autonomous Community or NUTS1) ,
all the comarcas of that level would be added.
\subsection{Legal Notice}{

The use of the information contained on the
\href{https://www.ine.es/en/index.htm}{INE website} may be carried out by users or
re-use agents, at their own risk, and they will be the sole liable parties
in the case of having to answer to third parties due to damages arising
from such use.
}
}
\section{About caching}{
You can set your \code{cache_dir} with \code{\link[=esp_set_cache_dir]{esp_set_cache_dir()}}.

Sometimes cached files may be corrupt. On that case, try re-downloading
the data setting \code{update_cache = TRUE}.

If you experience any problem on download, try to download the
corresponding .geojson file by any other method and save it on your
\code{cache_dir}. Use the option \code{verbose = TRUE} for debugging the API query.
}

\section{Displacing the Canary Islands}{
While \code{moveCAN} is useful for visualization, it would alter the actual
geographic position of the Canary Islands. When using the output for
spatial analysis or using tiles (e.g. with \code{\link[=esp_getTiles]{esp_getTiles()}} or
\code{\link[=addProviderEspTiles]{addProviderEspTiles()}})  this option should be set to \code{FALSE} in order to
get the actual coordinates, instead of the modified ones. See also
\code{\link[=esp_move_can]{esp_move_can()}} for displacing stand-alone \CRANpkg{sf} objects.
}

\examples{
\dontshow{if (esp_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
comarcas <- esp_get_comarca(moveCAN = FALSE)

library(ggplot2)

ggplot(comarcas) +
  geom_sf()

# Comarcas of Castille and Leon

comarcas_cyl <- esp_get_comarca("Castilla y Leon")

ggplot(comarcas_cyl) +
  geom_sf(aes(fill = ine.prov.name)) +
  labs(fill = "Province")

# Comarcas with Mountains or Alt(o,a) in the name

comarcas_alto <- esp_get_comarca(
  comarca = "Montaña|Monte|Sierra|Alt",
  epsg = 3857
)

ggplot(comarcas_alto) +
  geom_sf(aes(fill = ine.ccaa.name)) +
  geom_sf_text(aes(label = name), check_overlap = TRUE) +
  labs(fill = "CCAA")
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other political: 
\code{\link{esp_codelist}},
\code{\link{esp_get_can_box}()},
\code{\link{esp_get_capimun}()},
\code{\link{esp_get_ccaa}()},
\code{\link{esp_get_country}()},
\code{\link{esp_get_gridmap}},
\code{\link{esp_get_munic}()},
\code{\link{esp_get_nuts}()},
\code{\link{esp_get_prov}()},
\code{\link{esp_get_simpl_prov}()}
}
\concept{political}
