% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_make_provider.R
\name{esp_make_provider}
\alias{esp_make_provider}
\title{Create a custom tile provider}
\usage{
esp_make_provider(id, q, service, layers, ...)
}
\arguments{
\item{id}{An identifier for the user. Would be used also for identifying
cached tiles.}

\item{q}{The base url of the service}

\item{service}{The type of tile service, either \code{"WMS"} or \code{"WMTS"}.}

\item{layers}{The name of the layer to retrieve}

\item{...}{Additional parameters to the query, like \code{version}, \code{format},
\code{crs/srs}, \code{style}, ... depending on the capabilities of the service.}
}
\value{
A named list with two elements \code{id} and \code{q}.
}
\description{
Helper function for \code{\link[=esp_getTiles]{esp_getTiles()}} that helps to create a custom provider.
}
\details{
This function is meant to work with services provided as of the
\href{http://opengeospatial.github.io/e-learning/wms/text/operations.html#getmap}{OGC Standard}.

Note that:
\itemize{
\item \pkg{mapSpain} would not provide advice on the parameter \code{q} to be
provided.
\item Currently, on \strong{WMTS} requests only services with
\code{tilematrixset=GoogleMapsCompatible} are supported.
}
}
\examples{
\dontrun{
# This script downloads tiles to your local machine
# Run only if you are online

custom_wms <- esp_make_provider(
  id = "an_id_for_caching",
  q = "https://idecyl.jcyl.es/geoserver/ge/wms?",
  service = "WMS",
  layers = "geolog_cyl_litologia"
)

x <- esp_get_ccaa("Castilla y León", epsg = 3857)

mytile <- esp_getTiles(x, type = custom_wms)

tidyterra::autoplot(mytile) +
  ggplot2::geom_sf(data = x, fill = NA)
}
}
\seealso{
\code{\link[=esp_getTiles]{esp_getTiles()}}.

For a list of potential providers from Spain check
\href{https://www.idee.es/segun-tipo-de-servicio}{IDEE Directory}.

Other imagery utilities: 
\code{\link{addProviderEspTiles}()},
\code{\link{esp_getTiles}()},
\code{\link{esp_tiles_providers}}
}
\concept{imagery utilities}
