% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_ccaa.R
\name{esp_get_ccaa}
\alias{esp_get_ccaa}
\title{Get Autonomous Communities boundaries of Spain}
\usage{
esp_get_ccaa(ccaa = NULL, ...)
}
\arguments{
\item{ccaa}{A vector of names and/or codes for autonomous communities
or \code{NULL} to get all the autonomous communities. See Details.}

\item{...}{Additional parameters from \link{esp_get_nuts}.}
}
\value{
A \code{POLYGON/POINT} object.
}
\description{
Loads a simple feature (\code{sf}) object containing the
autonomous communities boundaries of Spain.
}
\details{
When using \code{ccaa} you can use and mix names and NUTS codes
(levels 1 or 2), ISO codes (corresponding to level 2) or \code{codauto}.
Ceuta and Melilla are considered as Autonomous Communities on this dataset.

When calling a NUTS1 level, all the Autonomous Communities of that level
would be added.
}
\examples{

library(sf)

# Random CCAA

Random <-
  esp_get_ccaa(ccaa = c("Euskadi",
                        "Catalunya",
                        "ES-EX",
                        "Canarias",
                        "ES52",
                        "01"))
plot(st_geometry(Random), col = hcl.colors(6))

# All CCAA of a Zone plus an addition

Mix <-
  esp_get_ccaa(ccaa = c("La Rioja", "Noroeste"),
               resolution = "20")
plot(
  Mix[, "nuts1.code"],
  pal = hcl.colors(2),
  key.pos = NULL,
  main = NULL,
  border = "white"
)
}
\seealso{
\link{esp_get_hex_ccaa}, \link{esp_get_nuts}, \link{esp_get_prov},
\link{esp_get_munic}, \link{esp_codelist}
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
