% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_ison.R
\docType{data}
\name{irps_blogs}
\alias{irps_blogs}
\title{One-mode directed network of links between US political blogs (Adamic and Glance 2005)}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{#> # A labelled, complex, directed network of 1490 blogs and 19090 link arcs
#> # A tibble: 1,490 x 3
#>   name                       Leaning Source               
#>   <chr>                      <chr>   <chr>                
#> 1 100monkeystyping.com       Liberal Blogarama            
#> 2 12thharmonic.com/wordpress Liberal BlogCatalog          
#> 3 40ozblog.blogspot.com      Liberal Blogarama,BlogCatalog
#> 4 4lina.tblog.com            Liberal Blogarama            
#> 5 750volts.blogspot.com      Liberal Blogarama            
#> 6 95theses.blogspot.com      Liberal Blogarama            
#> # i 1,484 more rows
#> # A tibble: 19,090 x 2
#>    from    to
#>   <int> <int>
#> 1   267  1394
#> 2   267   483
#> 3   267  1051
#> 4   904  1479
#> 5   904   919
#> 6   904  1045
#> # i 19,084 more rows
}\if{html}{\out{</div>}}
}
\usage{
data(irps_blogs)
}
\description{
This network consists of the blogosphere around the time of the 2004
US presidential election until February 2005.
The 2004 election was the first in which blogging played a significant role.
Ties were constructed from a crawl of the front page of each blog.

Political leaning is indicated as "Liberal" (or left leaning) or
"Conservative" (or right leaning), sourced from blog directories.
Some blogs were labelled manually,
based on incoming and outgoing links and posts.
}
\references{
Adamic, Lada, and Natalie Glance. 2005.
"The political blogosphere and the 2004 US Election: Divided they blog".
\emph{LinkKDD '05: Proceedings of the 3rd international workshop on Link discovery}, 36-43.
\doi{10.1145/1134271.1134277}
}
\keyword{datasets}
