% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_indirect.R
\name{print.indirect}
\alias{print.indirect}
\title{Print an 'indirect' Class
Object}
\usage{
\method{print}{indirect}(
  x,
  digits = 3,
  pvalue = NULL,
  pvalue_digits = 3,
  se = NULL,
  level = 0.95,
  se_ci = TRUE,
  wrap_computation = TRUE,
  ...
)
}
\arguments{
\item{x}{The output of
\code{\link[=indirect_effect]{indirect_effect()}} or
\code{\link[=cond_indirect]{cond_indirect()}}.}

\item{digits}{Number of digits to
display. Default is 3.}

\item{pvalue}{Logical. If \code{TRUE},
asymmetric \emph{p}-values based on
bootstrapping will be printed if
available. Default to \code{FALSE} if
confidence intervals have already
computed. Default to \code{TRUE} if
no confidence intervals have been
computed and the original standard
errors are to be used. See Details
on when the original standard errors
will be used by default. Default is
\code{NULL} and its value determined as
stated above.}

\item{pvalue_digits}{Number of decimal
places to display for the \emph{p}-value.
Default is 3.}

\item{se}{Logical. If \code{TRUE} and
confidence interval has been formed,
the standard error of the estimates
are also printed. It is simply the
standard deviation of the bootstrap
estimates or Monte Carlo simulated
values, depending on the method used
to form the confidence intervals.
Default to \code{FALSE} if
confidence interval has been
formed.
Default to \code{TRUE} if
no confidence interval has been
computed and the original standard
errors are to be used. See Details
on when the original standard errors
will be used by default.
Default is \code{NULL} and its value
determined as stated above.}

\item{level}{The level of confidence
for the confidence interval computed
from the original standard errors. Used only for
paths without mediators and both
\code{x}- and \code{y}-variables are not
standardized.}

\item{se_ci}{Logical. If \code{TRUE} and
confidence interval has not been
computed, the function will try
to compute them from stored
standard error if the original
standard error is to be used.
Ignored
if confidence interval has already
been computed. Default
to \code{TRUE}.}

\item{wrap_computation}{Logical.
If \code{TRUE}, the default, long
computational symbols and values
will be wrapped to fit to the screen
width.}

\item{...}{Other arguments. Not used.}
}
\value{
\code{x} is returned invisibly.
Called for its side effect.
}
\description{
Print the content of the
output of \code{\link[=indirect_effect]{indirect_effect()}} or
\code{\link[=cond_indirect]{cond_indirect()}}.
}
\details{
The \code{print} method of the
\code{indirect}-class object.

If bootstrapping confidence interval
was requested, this method has the
option to print a
\emph{p}-value computed by the
method presented in Asparouhov and Muthén (2021).
Note that this \emph{p}-value is asymmetric
bootstrap \emph{p}-value based on the
distribution of the bootstrap estimates.
It is not computed based on the
distribution under the null hypothesis.

For a \emph{p}-value of \emph{a}, it means that
a 100(1 - \emph{a})\% bootstrapping confidence
interval
will have one of its limits equal to
0. A confidence interval
with a higher confidence level will
include zero, while a confidence
interval with a lower confidence level
will exclude zero.

We recommend using confidence interval
directly. Therefore, \emph{p}-value is not
printed by default. Nevertheless,
users who need it can request it
by setting \code{pvalue} to \code{TRUE}.
\subsection{Using Original Standard Errors}{

If these conditions are met, the
stored standard error, if available,
will be used to test an effect and
form it confidence interval:
\itemize{
\item Confidence interval has not been
formed (e.g., by bootstrapping or
Monte Carlo).
\item The path has no mediators.
\item The model has only one group.
\item Both the \code{x}-variable and the
\code{y}-variable are not standardized.
}

If the model is fitted by OLS
regression (e.g., using \code{\link[stats:lm]{stats::lm()}}),
then the variance-covariance matrix
of the coefficient estimates will be
used, and the \emph{p}-value and confidence
interval are computed from the \emph{t}
statistic.

If the model is fitted by structural
equation modeling using \code{lavaan}, then
the variance-covariance computed by
\code{lavaan} will be used, and the \emph{p}-value
and confidence interval are computed
from the \emph{z} statistic.
}

\subsection{Caution}{

If the model is fitted by structural
equation modeling and has moderators,
the standard errors, \emph{p}-values,
and confidence interval computed
from the variance-covariance matrices
for conditional effects
can only be trusted if all covariances
involving the product terms are free.
If any some of them are fixed, for example,
fixed to zero, it is possible
that the model is not invariant to
linear transformation of the variables.
}
}
\examples{

library(lavaan)
dat <- modmed_x1m3w4y1
mod <-
"
m1 ~ a1 * x   + b1 * w1 + d1 * x:w1
m2 ~ a2 * m1  + b2 * w2 + d2 * m1:w2
m3 ~ a3 * m2  + b3 * w3 + d3 * m2:w3
y  ~ a4 * m3  + b4 * w4 + d4 * m3:w4
"
fit <- sem(mod, dat,
           meanstructure = TRUE, fixed.x = FALSE,
           se = "none", baseline = FALSE)
est <- parameterEstimates(fit)

wvalues <- c(w1 = 5, w2 = 4, w3 = 2, w4 = 3)

indirect_1 <- cond_indirect(x = "x", y = "y",
                            m = c("m1", "m2", "m3"),
                            fit = fit,
                            wvalues = wvalues)
indirect_1

dat <- modmed_x1m3w4y1
mod2 <-
"
m1 ~ a1 * x
m2 ~ a2 * m1
m3 ~ a3 * m2
y  ~ a4 * m3 + x
"
fit2 <- sem(mod2, dat,
            meanstructure = TRUE, fixed.x = FALSE,
            se = "none", baseline = FALSE)
est <- parameterEstimates(fit)

indirect_2 <- indirect_effect(x = "x", y = "y",
                              m = c("m1", "m2", "m3"),
                              fit = fit2)
indirect_2
print(indirect_2, digits = 5)


}
\references{
Asparouhov, A., & Muthén, B. (2021). Bootstrap p-value computation.
Retrieved from https://www.statmodel.com/download/FAQ-Bootstrap\%20-\%20Pvalue.pdf
}
\seealso{
\code{\link[=indirect_effect]{indirect_effect()}} and
\code{\link[=cond_indirect]{cond_indirect()}}
}
