% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_flextable.cond_indirect_effects.R
\name{as_flextable.cond_indirect_effects}
\alias{as_flextable.cond_indirect_effects}
\title{Convert an 'cond_indirect_effects' Object to a 'flextable' Object}
\usage{
\method{as_flextable}{cond_indirect_effects}(
  x,
  pvalue = FALSE,
  se = TRUE,
  var_labels = NULL,
  digits = 2,
  pval_digits = 3,
  use_arrow = TRUE,
  indirect_raw = TRUE,
  indirect_raw_ci = indirect_raw,
  indirect_raw_se = indirect_raw,
  footnote = TRUE,
  show_wvalues = TRUE,
  show_indicators = FALSE,
  show_path = TRUE,
  pcut = 0.001,
  ...
)
}
\arguments{
\item{x}{The object to be converted.
Should be of the class \code{cond_indirect_effects}
from the package \code{manymome}.}

\item{pvalue}{If bootstrap confidence
intervals are stored, whether
asymmetric \emph{p}-values are reported.
Default is \code{FALSE}.
See
\code{manymome::print.cond_indirect_effects()}
for the computational details.}

\item{se}{Whether standard errors
are reported if confidence intervals
are stored. Default is \code{TRUE}.
See
\code{manymome::print.cond_indirect_effects()}
for the computation details.}

\item{var_labels}{A named vectors.
Used to replace variable names by
other names when generating the
table. For example,
\code{c(x = "I.V", y = "D.V.")} replaces
\code{x} by \code{"I.V"} and \code{y} by \code{"D.V."}
in the output.}

\item{digits}{The number of digits
to be displayed for most numerical
columns,
such as effect estimates, standard
errors, and confidence intervals.
Default is 2.}

\item{pval_digits}{The number of
digits to be displayed for the
\emph{p}-value column, if present. Default
is 3.}

\item{use_arrow}{If \code{TRUE}, the
default, use the arrow symbol in
the paths.}

\item{indirect_raw}{If \code{TRUE}, the
default, report unstandardized effects
even if standardization was done.}

\item{indirect_raw_ci}{If \code{TRUE},
report the confidence intervals
of unstandardized effects
even if standardization was done
and confidence intervals were stored.
Default to be equal to \code{indirect_raw}.
NOTE: Not used for now. Always \code{FALSE}.}

\item{indirect_raw_se}{If \code{TRUE},
report the standard errors
of unstandardized effects
even if standardization was done
and confidence intervals were stored.
Default to be equal to \code{indirect_raw}.
NOTE: Not used for now. Always \code{FALSE}.}

\item{footnote}{If \code{TRUE}, the
default,
add footnote(s) regarding the results
to the bottom of the table.}

\item{show_wvalues}{Whether the values
of moderators will be shown. If \code{FALSE},
no values will be shown, even for
categorical moderators. Default is
\code{TRUE}.}

\item{show_indicators}{Whether the values
of indicators (dummy variables) will
be shown for categorical moderators.
Default is \code{FALSE}.}

\item{show_path}{Whether the paths
being moderated will be displayed.
Default is \code{TRUE}.}

\item{pcut}{Any \emph{p}-value less than
\code{pcut} will be displayed as
\verb{<[pcut]}, \code{"[pcut]"} replaced by
the value of \code{pcut}. Default is .001.}

\item{...}{Additional arguments.
Ignored.}
}
\value{
A \code{flextable} object.
}
\description{
The 'as_flextable' method
for the output of 'manymome::many_indirect_effects()'.
}
\details{
It converts an \code{cond_indirect_effects}
object,
which is usually created by
\code{\link[manymome:cond_indirect]{manymome::cond_indirect_effects()}},
to a \code{flextable} object. The output
can be further modified by functions
from the \code{flextable} package.
}
\examples{

library(manymome)
library(flextable)

# List of indirect effects

dat <- data_med_mod_a
lm_m <- lm(m ~ x*w + c1 + c2, dat)
lm_y <- lm(y ~ m + x + c1 + c2, dat)
fit_lm <- lm2list(lm_m, lm_y)

# Should set R to 5000 or 10000 in real research
boot_out_lm <- do_boot(fit_lm,
                       R = 100,
                       seed = 54532,
                       parallel = FALSE,
                       progress = FALSE)

out_xmy_on_w <- cond_indirect_effects(wlevels = "w",
                                      x = "x",
                                      y = "y",
                                      m = "m",
                                      fit = fit_lm,
                                      boot_ci = TRUE,
                                      boot_out = boot_out_lm)

std_xmy_on_w <- cond_indirect_effects(wlevels = "w",
                                      x = "x",
                                      y = "y",
                                      m = "m",
                                      fit = fit_lm,
                                      boot_ci = TRUE,
                                      boot_out = boot_out_lm,
                                      standardized_x = TRUE,
                                      standardized_y = TRUE)

ft1 <- as_flextable(out_xmy_on_w,
                    var_labels = c(w = "Moderator"))
ft1

ft2 <- as_flextable(std_xmy_on_w,
                    var_labels = c(w = "Moderator"),
                    se = FALSE,
                    digits = 3)
ft2

}
