% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wwtp_functions.R
\name{wwtp_process_complete}
\alias{wwtp_process_complete}
\title{Complete WWTP Processing Pipeline}
\usage{
wwtp_process_complete(
  nitrogen_path = NULL,
  phosphorus_path = NULL,
  column_mapping = NULL,
  skip_rows = 0,
  header_row = 1,
  load_units = "kg",
  verbose = TRUE
)
}
\arguments{
\item{nitrogen_path}{Character. Path to nitrogen WWTP data (if NULL, loads from OSF)}

\item{phosphorus_path}{Character. Path to phosphorus WWTP data (if NULL, loads from OSF)}

\item{column_mapping}{Named list. Custom column mapping for user data}

\item{skip_rows}{Numeric. Rows to skip in user files}

\item{header_row}{Numeric. Header row in user files}

\item{load_units}{Character. Units of loads in user files}

\item{verbose}{Logical. Show processing messages}
}
\value{
List with processed nitrogen and phosphorus WWTP data
}
\description{
Run complete WWTP processing pipeline for both nutrients
}
\examples{
\donttest{
# Process built-in OSF data (2016 default)
wwtp_results_builtin <- wwtp_process_complete(
  nitrogen_path = NULL,     # Use built-in data
  phosphorus_path = NULL,   # Use built-in data
  verbose = TRUE
)

# Process custom user data
# wwtp_results_custom <- wwtp_process_complete(
#   nitrogen_path = "nitrogen_2020.csv",
#   phosphorus_path = "phosphorus_2020.csv",
#   load_units = "lbs"
# )

# Mixed: OSF for one nutrient, custom for another
# wwtp_results_mixed <- wwtp_process_complete(
#   nitrogen_path = NULL,           # Use OSF built-in
#   phosphorus_path = "custom_P.csv" # Use custom
# )
}
}
