% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manifesto.R
\name{mp_view_originals}
\alias{mp_view_originals}
\title{View original documents from the Manifesto Corpus Database}
\usage{
mp_view_originals(ids, maxn = 5, apikey = NULL, cache = TRUE)
}
\arguments{
\item{ids}{Information on which originals to view This can either be a
    list of partys (as ids) and dates of elections as given to
    \code{\link{mp_metadata}} or a \code{ManifestoMetadata} object
    (\code{data.frame}) as returned by \code{\link{mp_metadata}}.
Alternatively, ids can be a logical expression specifying a subset of
the Manifesto Project's main dataset. It will be evaluated within the
data.frame returned by \code{\link{mp_maindataset}} such that all its
variables and functions thereof can be used in the expression.}

\item{maxn}{maximum number of documents to open simultaneously in browser,
defaults to 5.}

\item{apikey}{API key to use. Defaults to \code{NULL}, resulting in using
the API key set via \code{\link{mp_setapikey}}.}

\item{cache}{Boolean flag indicating whether to use locally cached data if
available. The original documents themselves are not cached locally,
but the metadata required to find them is.}
}
\description{
Original documents are opened in the system's browser window. All original
documents are stored on the Manifesto Project Website and the URLs opened
are all from this site.
}
\examples{
\dontrun{
mp_view_originals(party == 41320 & date == 200909)
}
}
