% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clarity.R
\name{mp_clarity}
\alias{mp_clarity}
\title{Programmatic clarity measures (PC)}
\usage{
mp_clarity(data, weighting_kind = "party", weighting_source = NULL,
  auto_rescale_weight = TRUE, auto_rescale_variables = TRUE,
  dimensions = clarity_dimensions())
}
\arguments{
\item{data}{a dataframe or matrix in format of Manifesto Project Main Dataset}

\item{weighting_kind}{party or country-specific weighting of the dimensions}

\item{weighting_source}{name of variable with party importance weighting (can be rmps, pervote)}

\item{auto_rescale_weight}{rescale weights to 0-1}

\item{auto_rescale_variables}{rescale dimension variables to 0-1}

\item{dimensions}{dimensions to be used, must be in the format of the return value of \code{\link{clarity_dimensions}}}
}
\value{
a vector of clarity values
}
\description{
Computes party clarity measures suggested by 
Giebler/Lacewell/Regel/Werner 2015.
}
\references{
Giebler, Heiko, Onawa Promise Lacewell, Sven Regel and Annika Werner. 2015. 
Niedergang oder Wandel? Parteitypen und die Krise der repraesentativen Demokratie. 
In Steckt die Demokratie in der Krise?, ed. Wolfgang Merkel, 181-219. Wiesbaden: Springer VS.
}

