% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delineate_with_identification.R
\name{delineate_with_identification}
\alias{delineate_with_identification}
\title{Delineate clusters from taxonomic identifications}
\usage{
delineate_with_identification(tibble_report)
}
\arguments{
\item{tibble_report}{A tibble of \emph{n} rows, with \emph{n} the number of spectra,
produced by \code{\link[=read_biotyper_report]{read_biotyper_report()}} or \code{\link[=read_many_biotyper_reports]{read_many_biotyper_reports()}}. The long format and the best hits options are expected to be used in these functions to produce a compliant input tibble.}
}
\value{
A tibble of \emph{n} rows for each spectra and 3 columns:
\itemize{
\item \code{name}: the spectra names from the \code{name} column from the output of either \code{\link[=read_biotyper_report]{read_biotyper_report()}} or \code{\link[=read_many_biotyper_reports]{read_many_biotyper_reports()}}.
\item \code{membership}: integers stating the cluster number to which the spectra belong to. It starts from 1 to \emph{c}, the total number of clusters.
\item \code{cluster_size}: integers indicating the total number of spectra in the corresponding cluster.
}
}
\description{
From the report of taxonomic identification produced by the Bruker MALDI Biotyper
spectra sharing the same identification are labeled in the same cluster.
Spectra with unknown identification (e.g., due to database completeness) are set in unique cluster.
}
\details{
As all unknown identification are considered unique clusters \emph{within one input tibble}, it is important to consider whether the taxonomic identifications come from a single report or multiple reports, depending on the research question. A message is displayed to confirm from which type of reports the delineation was done.
}
\examples{
report_unknown <- read_biotyper_report(
  system.file("biotyper_unknown.csv", package = "maldipickr")
)
delineate_with_identification(report_unknown)
}
\seealso{
\link{delineate_with_similarity}
}
