% Generated by roxygen2 (4.0.0): do not edit by hand
\name{\%>\%}
\alias{\%>\%}
\title{Pipe an object forward into a function call/expression.}
\usage{
lhs \%>\% rhs
}
\arguments{
\item{lhs}{The value to be piped}

\item{rhs}{A function or expression}
}
\description{
The \code{\%>\%} operator pipes the left-hand side into an expression on the
right-hand side. The expression can contain a \code{.} as placeholder to
indicate the position taken by the object in the pipeline. If not present,
value  will be placed as the first argument. If the right-hand side
expression is a function call that takes only one argument, one can omit
parentheses and the \code{.}. Only the outmost call is matched against the
dot, which means that e.g. formulas can still use a dot which will not be
matched. Nested functions will not be matched either.
}
\details{
When the right-hand side expression is enclosed in parentheses, it is
evaluated before the left-hand side is passed on, which can be
used when the right-hand side itself evaluates to the relevant
function or call. It is advised, but not strictly necessary, to parenthesize
anonymous function definitions when used in pipelines.
}
\examples{
\dontrun{
library(dplyr)
library(Lahman)

Batting \%>\%
  group_by(playerID) \%>\%
  summarise(total = sum(G)) \%>\%
  arrange(desc(total)) \%>\%
  head(5)


iris \%>\%
  filter(Petal.Length > 5) \%>\%
  select(-Species) \%>\%
  colMeans

iris \%>\%
  aggregate(. ~ Species, ., mean)

rnorm(1000) \%>\% abs \%>\% sum
}

rnorm(1000) \%>\%
 (function(x) {
   hist(x)
   x
 })

1:10 \%>\% (call("sum"))

1:10 \%>\% (substitute(a(), list(a = sum)))
}

