\name{plot.evolution}
\Rdversion{1.1}
\alias{plot.evolution}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Plot Various Properties of the Simulation Result
}
\description{
  Depending on the input, this function is able to plot the time
  dependence of free energy, magnitudes
  of specific spins, specific components of specific spins
}
\usage{
\method{plot}{evolution} (x = NA, spins = NULL, components = NULL, \dots)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
    the simulation result, an evolution object generated by
    \code{\link{multispin.evol}}. If only \code{x} is given, then this
    function will plot the time-dependence of free energy, just like
    \code{\link{free.energy}} and \code{\link{plot.free.energy}}.
}
  \item{spins}{
    a vector of integers each of which represents a micro-spin. If 
    \code{g} and \code{spins} are the only given arguments, then this
    function will plot the time-dependence of the magnitudes of these
    spins with different colors. This is used to double-check that the
    magnitudes of the spins are kept exactly 1 during the simulation.
}
\item{components}{
  a vector of integers \eqn{1,2,3} each of which represents one specific
  component of the spin defined in \code{spin} and this function will
  plot the corresponding components for the spins. This argument must be
  given together with \code{spins} and have the same length as
  \code{spins} or length 1 if you want to plot the same component for
  \code{spins}.
    
}

  \item{...}{
    additional arguments, passed to \code{\link{plot}}
  }

}

\references{
  check out the references in \code{\link{multispin.evol}}
}
\author{
  Hai Qian, Electrical Engineering Department, UCLA
}

\seealso{
  \code{\link{multispin.evol}} to generate \code{g} and check out the
  examples there

  \code{\link{plot.free.energy}} to plot the time-dependence of the
  system free energy

  \code{\link{magnitude}} to calculate the magnitude of the spins
}

