% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMetadata.R
\name{getMetadata}
\alias{getMetadata}
\alias{getMetadata<-}
\title{getMetadata (!experimental!)}
\usage{
getMetadata(x, type = NULL)

getMetadata(x, type = NULL) <- value
}
\arguments{
\item{x}{MAgPIE object}

\item{type}{A vector containing the Metadata field. If NULL, getMetadata() will return all 
non-NULL fields, and 'getMetadata<-' will update all fields specified in value.}

\item{value}{An object containing the Metadata entry.}
}
\value{
getMetadata returns the metadata attached to a MAgPIE-object, NULL if
no metadata attribute is present. getMetadata<- returns the magpie object with the
modified metadata.
}
\description{
This function is currently experimental and non-functional by default! To activate it,
set withMetadata(TRUE), otherwise it will not return or modify any metadata!
}
\details{
The function allows users to set and retrieve metadata for magclass objects 

Metadata is an attribute of a magclass object, and it includes the default 
fields of "unit", "source", "date", "user", "calcHistory", "description" 
and "note", all contained in a list.

The "source" element is stored as a Bibtex class object (or a list thereof), but the value argument 
here can be either a Bibtex or bibentry object (or a list of any combination). Include all relevant 
information regarding where the data was originally reported. Specifically, the type of publication,
author(s), article title, journal/publication name, volume, page numbers, URL and DOI.

The "calcHistory" field is stored as a Node class object. The value argument can be either a single
node, a character of length 1 (to be converted to a node), or a full data tree. In the first two cases, 
the provided value will become the root node (read as the most recent function applied to the object).
In the case of a full tree input, this will replace any existing calcHistory. Use updateMetadata() to 
merge the calcHistory of two magpie objects.
}
\section{Functions}{
\itemize{
\item \code{getMetadata<-}: set and modify Metadata
}}

\examples{
 \dontrun{
   withMetadata(TRUE)
   a <- as.magpie(1)
   #returns NULL
   getMetadata(a)
   #set the unit field
   getMetadata(a, "unit") <- "GtCO2eq"
   getMetadata(a)
 
   #set all Metadata fields
   M <- list(unit='kg', source=list(author='John Doe', date='January 1, 2017', 
   title='example', publication='BigJournal, Vol. 200, pp. 100-115', institution='IEA'), 
   date=as.character(Sys.time()), user='my name', calcHistory=list('downloadSource','readSource'), 
   description='nonsense data')
   getMetadata(a) <- M
   getMetadata(a)
   withMetadata(FALSE)
 }
}
\seealso{
\code{\link{getComment}}, \code{\link{getRegions}}, \code{\link{getNames}},
\code{\link{getYears}}, \code{\link{getCPR}}, \code{\link{read.magpie}},
\code{\link{write.magpie}}, \code{"\linkS4class{magpie}"}
}
\author{
Stephen Bi
}
