% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy.attributes.R
\name{copy.attributes}
\alias{copy.attributes}
\alias{copy.attributes<-}
\title{Copy Attributes}
\usage{
copy.attributes(from, to, delete = c("names", "row.names", "class",
  "dim", "dimnames"), delete2 = NULL)

copy.attributes(to, delete = c("names", "row.names", "class", "dim",
  "dimnames"), delete2 = NULL) <- value
}
\arguments{
\item{from}{object from which the attributes should be taken}

\item{to}{object to which the attributes should be written}

\item{delete}{attributes which should not be copied. By default this are
class specific attributes which might cause problems if copied to another
object. But you can add or remove attributes from the vector.}

\item{delete2}{Identical to delete and just added for convenience for the
case that you want to delete additional attributes but do not want to repeat
the vector given in delete. In the function both vectors, delete and
delete2, are just merged to one deletion vector.}

\item{value}{Same as "from" (object from which the attributes should be
taken)}
}
\description{
This function copies attributes from one object and assigns them to another.
}
\section{Functions}{
\itemize{
\item \code{copy.attributes<-}: assign attributes from object "value"
}}

\examples{

from <- array(12)
attr(from,"blablub") <- "I am an attribute!"
attr(from,"blablub2") <- "I am another attribute!"

print(attributes(from))

to <- as.magpie(0)
print(attributes(to))

copy.attributes(to) <- from
print(attributes(to))

}
\author{
Jan Philipp Dietrich
}
