% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getConfig.R
\name{getConfig}
\alias{getConfig}
\title{getConfig}
\usage{
getConfig(option = NULL, raw = FALSE, verbose = TRUE, print = FALSE)
}
\arguments{
\item{option}{The option for which the setting should be returned. If set to
NULL all options are returned.}

\item{raw}{If set to FALSE some settings will be calculated, e.g. if the
cache folder is set to FALSE the full path will be calculated using the
main folder, or if the verbosity is not set the default verbosity will be
returned. If raw is set to TRUE settings are returned as they are currently
stored.}

\item{verbose}{boolean deciding whether status information/updates should be shown or not}

\item{print}{if TRUE and verbose is TRUE a configuration overview will also get printed}
}
\value{
A config list with all settings currently set for the madrat package
}
\description{
This function returns the madrat config which is currently loaded. If no
configuration has been loaded so far the configuration will be initialized
with default settings or system settings (if available).
}
\note{
\code{getConfig} is primarily designed to make the overall madrat
configuration available to system tools of the madrat framework. There are
only a few exceptions for which configuration settings are also readable
from within a download-, read-, convert-, correct-, calc- or full-function.
These exceptions are the setting "debug" (which can be used to add additional
debug messages when active), the "tmpfolder" which can be used to temporarily
store data and the setting "hash" (which can only be accessed from within a
full function and can there be used to apply the identical hash algorithm for
other calculations in which hashing is being used).
Besides that "regionmapping" and "extramappings" can also be read from within
calc- and full-functions but their use is at least for the calc-functions
discouraged as it either might lead to incorrect caching behavior, or - if
implemented correctly - lead to significant slow-downs of overall calculations.
All other settings are currently still accessible but trigger a warning that
this option will soon be removed. So, please make sure that your code runs
without reading these options!
As a background note: Read access to these settings will be restricted as they
otherwise would allow access to code elements or data in a form which is
violating the overall madrat logic and thereby can lead to erroneous results.
}
\seealso{
\code{\link{setConfig}}, \code{\link{initializeConfig}}
}
\author{
Jan Philipp Dietrich
}
