% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSources.R
\name{getSources}
\alias{getSources}
\title{getSources}
\usage{
getSources(
  name = NULL,
  type = NULL,
  packages = getConfig("packages"),
  globalenv = getConfig("globalenv")
)
}
\arguments{
\item{name}{name of function for which sources should get returned. If not specified, all sources in the
specified environment are returned}

\item{type}{Type of source, either set to "read", "convert", "correct", "download" or
NULL. If specified, a vector containing the sources with the corresponding function type are returned,
otherwise a data.frame with all sources and their available function types is returned.}

\item{packages}{A character vector with packages for which the available Sources/Calculations should be returned}

\item{globalenv}{Boolean deciding whether sources/calculations in the global environment should be included or not}
}
\value{
A vector or data.frame containing all corresponding sources
}
\description{
These functions can be used to retrieve a list of currently available
sources and outputs (based on the availability of corresponding conversion
functions in the loaded data data processing packages.)
}
\note{
Please be aware that these functions only check the availability of corresponding functions of the package, not
whether the functions will properly work.
}
\examples{

print(getSources())

}
\seealso{
\code{\link{readSource}}, \code{\link{setConfig}}
}
\author{
Jan Philipp Dietrich
}
