% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolCountryFill.R
\name{toolCountryFill}
\alias{toolCountryFill}
\title{Tool: CountryFill}
\usage{
toolCountryFill(x, fill = NA, no_remove_warning = NULL,
  overwrite = FALSE, verbosity = 1, ...)
}
\arguments{
\item{x}{MAgPIE object with ISO country codes in the spatial dimension}

\item{fill}{Number which should be used for filling the gaps of missing
countries.}

\item{no_remove_warning}{A vector of non-ISO country codes that exist in the
data and that should be removed by CountryFill but without creating a
warning (they will be removed in any case). You should use that argument if
you are certain that the given entries should be actually removed from the
data.}

\item{overwrite}{logical deciding whether existing data should be overwritten,
if there is a specific mapping provided for that country, or not}

\item{verbosity}{verbosity for information about filling important countries.
0 = warning will show up (recommended if filling of important countries is not expected), 
1 = note will show up in reduced log file (default),
2 = info will show up in extended log file (recommended if filling of important countries
is not critical and desired).}

\item{...}{Mappings between countries for which the data is missing and 
countries from which the data should be used instead for these countries 
(e.g. "HKG"="CHN" if HongKong should receive the value of China). This 
replacement usually only makes sense for intensive values.}
}
\value{
A MAgPIE object with spatial entries for each country of the
official ISO code country list.
}
\description{
This function expects a MAgPIE object with ISO country codes in the spatial
dimension. These ISO codes are compared with the official ISO code country
list (stored as supplementary data in the madrat package). If there is an
ISO code in the data but not in the official list this entry is removed, if
an entry of the official list is missing in the data this entry is added and
set to the value of the argument fill.
}
\examples{

library(magclass)
x <- new.magpie("DEU",1994,"bla",0)
y <- toolCountryFill(x,99)

}
\author{
Jan Philipp Dietrich
}
