% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotdiagnostics.R
\name{plotDiagnostics}
\alias{plotDiagnostics}
\title{Diagnostics plot}
\usage{
plotDiagnostics(filename, scale = "sqrt", cumulate_time = FALSE,
  png = NULL)
}
\arguments{
\item{filename}{path to a diagnostics file as created with the setConfig argument diagnostics}

\item{scale}{defines how time should scale the size of the vertices in the network. Available options
are linear (lin), logarithmic (log) and square-root (sqrt).}

\item{cumulate_time}{if set to TRUE the size of each node will reflect the cumulated execution time of the corresponding 
function (including the execution time of all underlying functions). If set to FALSE it will only show the net time
spend in this function (excluding underlying functions).}

\item{png}{png file name to save the plot as a png. If !NULL the function will wait until the interactive plot window will be closed
and will then print the picture as it was in this window (still experimental!).}
}
\description{
Function that plot diagnostic data from a madrat run and shows the network of function executions 
and distribution of time consumption
}
\examples{

\dontrun{
plotDiagnostics("diagnostics.csv")
}

}
\seealso{
\code{\link{toolstartmessage}}, \code{\link{setConfig}}
}
\author{
Jan Philipp Dietrich
}
