% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cliBioCliIdx.R
\name{cliBioCliIdxGrid}
\alias{cliBioCliIdxGrid}
\title{Calculator for Bioclimatic Indices}
\usage{
cliBioCliIdxGrid(
  rs.temp,
  rs.prec,
  rs.bsdf = NULL,
  rl.elv = NULL,
  sc.year = 2000,
  rl.MSMC = 150,
  aprchTEMP = c("hip", "tsi", "const"),
  aprchPREC = c("tsi", "hip", "const"),
  aprchBSDF = c("hip", "const"),
  dvTEMP = rep(0.7, 12),
  dvPREC = rep(0.7, 12),
  bciOpVar = c("abt", "tap", "per", "fai"),
  filename = "",
  ...
)
}
\arguments{
\item{rs.temp}{multi-layer Raster* object with one-year time series of monthly mean air temperature (in °C)}

\item{rs.prec}{multi-layer Raster* object with one-year time series of monthly precipitation sum (in mm)}

\item{rs.bsdf}{multi-layer Raster* object with one-year time series of monthly mean relative sunshine duration
(dimensionless)}

\item{rl.elv}{single-layer Raster* object with the elevation values (in meters above sea level)}

\item{sc.year}{'numeric' scalar with the value of the year (using astronomical year numbering)}

\item{rl.MSMC}{'numeric' scalar or single-layer Raster* object with the value/values of the maximum soil moisture
capacity (aka 'bucket size') (in mm)}

\item{aprchTEMP}{'character' vector of length 1 that indicates the scheme used to generate daily values of the
daily mean air temperature for a specific year. Valid values are as follows: \cr
(a) \code{'hip'} -
this scheme applies the mean-preserving 'harmonic' interpolation method of Epstein (1991) to the values of
monthly mean air temperature in order to generate daily values; \cr
(b) \code{'tsi'} -
this scheme uses an iterative interpolation technique (Lüdeke et al. 1994) to time series of the monthly mean
air temperature, in order to generate a synthetic time series of the selected meteorological variable at a
temporal resolution that is higher than the daily scale; finally, this synthetic time series is upscaled to a
daily resolution; \cr
(c) \code{'const'} -
this scheme is assumed that values of the daily mean air temperature are constant within each month.}

\item{aprchPREC}{'character' vector of length 1 that indicates the scheme to generate daily values of the
daily precipitation sum. Valid values are as follows: \cr
(a) \code{'tsi'} -
this scheme uses an iterative interpolation technique (Lüdeke et al. 1994) to time series of the monthly mean
precipitation intensity, in order to generate a synthetic time series of the selected meteorological variable
at a temporal resolution that is higher than the daily scale; finally, this synthetic time series is upscaled
to a daily resolution; \cr
(b) \code{'hip'} -
this scheme applies the mean-preserving 'harmonic' interpolation method of Epstein (1991) to the values of
monthly mean precipitation intensity in order to generate daily values; \cr
(c) \code{'const'} -
this scheme is assumed that values of the daily precipitation sum are constant within each month (the monthly
precipitation sum is divided equally across each day of the month).}

\item{aprchBSDF}{'character' vector of length 1 that indicates the scheme used to generate daily values of the
daily fractional sunshine duration for a specific year. Valid values are as follows: \cr
(a) \code{'hip'} -
this scheme applies the mean-preserving 'harmonic' interpolation method of Epstein (1991) to the values of
monthly mean relative sunshine duration in order to generate daily values; \cr
(b) \code{'const'} -
this scheme is assumed that values of the daily relative sunshine duration are constant within each month.}

\item{dvTEMP}{'numeric' vector of length 12 with monthly values of the damping variable for the air temperature
data.}

\item{dvPREC}{'numeric' vector of length 12 with monthly values of the damping variable for the precipitation data.}

\item{bciOpVar}{'character' vector of at least one length that indicates which of the bioclimatic indices is/are
to be computed. Valid values are as follows: \cr
(a) \code{'abt'} - Mean Annual Biotemperature (in °C); \cr
(b) \code{'tap'} - Total Annual Precipitation (in mm); \cr
(c) \code{'per'} - Potential Evapotranspiration Ratio (dimensionless); \cr
(d) \code{'fai'} - Forestry Aridity Index (dimensionless); \cr
(e) \code{'gdd0'} - Growing Degree-Days on 0°C base (in °C day); \cr
(f) \code{'gdd5'} - Growing Degree-Days on 5°C base (in °C day);  \cr
(g) \code{'bdi'} - Budyko's Dryness Index (dimensionless); \cr
(h) \code{'cci'} - Condrad's Continentality Index (in per cent);  \cr
(i) \code{'mat'} - Mean Annual Temperature (in °C); \cr
(j) \code{'tc'} - Mean Temperature of the Coldest Month (in °C); \cr
(k) \code{'tw'} - Mean Temperature of the Warmest Month (in °C);  \cr
(l) \code{'tm10'} - Number of Months with Mean Temperature above 10°C (dimensionless);  \cr
(m) \code{'pdry'} - Precipitation Sum of the Driest Month (in mm); \cr
(n) \code{'psdry'} - Precipitation Sum of the Driest Month in the Summer Half-Year (in mm); \cr
(o) \code{'pwdry'} - Precipitation Sum of the Driest Month in the Winter Half-Year (in mm); \cr
(p) \code{'pswet'} - Precipitation Sum of the Wettest Month in the Summer Half-Year (in mm); \cr
(q) \code{'pwwet'} - Precipitation Sum of the Wettest Month in the Winter Half-Year (in mm); \cr
(r) \code{'ps'} - Precipitation Sum of the Summer Half-Year (in mm); \cr
(s) \code{'pw'} - Precipitation Sum of the Winter Half-Year (in mm); \cr
(t) \code{'ptc'} - Priestley–Taylor Coefficient (dimensionless).}

\item{filename}{output filename}

\item{...}{additional arguments passed on to \code{\link[raster]{writeRaster}}}
}
\value{
A RasterStack with one or more layers where each layer contain the values of a given bioclimatic index.
}
\description{
Calculates the values of selected bioclimatic indices, for a given region and year/epoch, by using the
    monthly time series of temperature, precipitation and relative sunshine duration, and the elevation data.
}
\details{
See \code{\link[macroBiome]{cliBioCliIdxPoints}}.
}
\note{
The objects \code{'rs.temp'}, \code{'rs.prec'} and \code{'rs.bsdf'} must be 12-layer Raster* objects, while
    the object \code{'rl.elv'} has to be a single-layer Raster* object. The object \code{'rl.MSMC'} must be either
    a single positive number (a universal bucket size) or a single-layer Raster* object (a regionally-specified
    bucket size). These Raster* objects must have the same bounding box, projection, and resolution. The object
    \code{'sc.year'} has to be a single integer number.
}
\examples{
# Loading mandatory data for the Example 'Climate Normal Grid'
data(inp_exClnrGrid)

# Calculate values of all default bioclimatic indices with default settings
# for Csongrad-Csanad County (for the normal period 1981-2010)
with(inp_exClnrGrid, {
rs.bci1 <- cliBioCliIdxGrid(temp, prec)
rs.bci1
})

\donttest{
# Calculate values of all selected bioclimatic indices with default settings
# for Csongrad-Csanad County (for the normal period 1981-2010)
with(inp_exClnrGrid, {
year <- trunc(mean(seq(1981, 2010)))
bciOpVar <- c("gdd5", "bdi", "cci", "tc", "gdd0", "tw", "ptc")
rs.bci2 <- cliBioCliIdxGrid(temp, prec, bsdf, elv, sc.year = year, bciOpVar = bciOpVar)
rs.bci2
})
}

}
\references{
\cite{Epstein ES (1991) On Obtaining Daily Climatological Values from Monthly Means. J Clim 4(3):365–368.
    \doi{10.1175/1520-0442(1991)004<0365:OODCVF>2.0.CO;2}}

\cite{Lüdeke MKB, Badeck FW, Otto RD, Häger C, Dönges S, Kindermann J, Würth G, Lang T, Jäkel U, Klaudius A,
    Ramge P, Habermehl S, Kohlmaier GH (1994) The Frankfurt Biosphere Model: A global process-oriented model of
    seasonal and long-term CO2 exchange between terrestrial ecosystems and the atmosphere. I. Model description
    and illustrative results for cold deciduous and boreal forests. Clim Res 4(2):143-166. \doi{10.3354/cr004143}}
}
