% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cliBrtSunDurFrc.R
\name{cliBrtSunDurFrcGrid}
\alias{cliBrtSunDurFrcGrid}
\title{Estimator for Fraction of Bright Sunshine Duration}
\usage{
cliBrtSunDurFrcGrid(
  rs.temp,
  rs.prec,
  rl.elv,
  sc.year = 2000,
  aprchSIM = c("Solar123", "SPLASH"),
  filename = "",
  ...
)
}
\arguments{
\item{rs.temp}{multi-layer Raster* object with one-year time series of monthly mean air temperature (in °C)}

\item{rs.prec}{multi-layer Raster* object with one-year time series of monthly precipitation sum (in mm)}

\item{rl.elv}{single-layer Raster* object with the elevation values (in meters above sea level)}

\item{sc.year}{'numeric' scalar with the value of the year (using astronomical year numbering)}

\item{aprchSIM}{'character' vector of length 1 that indicates the formula used to estimate the value of solar
irradiance/irradiation for a specific day. Valid values are as follows: \cr
(a) \code{'Solar123'} -
in this approach, first, the mean hourly solar irradiance under cloudless-sky conditions is calculated as
proposed by Yin (1997b), with a minor modification, using the daytime means of optical air mass and
cosine zenith; the former is computed as recommended by Yin (1997b), while the latter is estimated by using
Eq 5 of Yin (1997a); however, in contrast to the original approach, where the solar constant was fixed at
\eqn{4.9212 MJ m^{-2} hr^{-1}}{4.9212 MJ m^{-2} hr^{-1}}, according to Yin (1999), its value is corrected by
calendar day for the variable ellipticity of the Earth's orbit, by using the scheme of Brock (1981); in the
calculations, the values of solar declination and daylength are derived by using the approach of Brock (1981);
\cr
(b) \code{'SPLASH'} -
in this approach, first, under varying orbital parameters, the daily solar radiation at the top of the
atmosphere is calculated (\eqn{H_{0}}{H_{0}}, Eq 7 in Davis et al. (2017)), and then this value is
multiplied by the atmospheric transmittivity to obtain the value of daily surface radiation; in this case as
well, cloudless conditions are assumed, i.e., the transmission coefficient is taken into account with an
universal value of 0.75, however, its value is modified as a function of elevation, by using the scheme of
Allen (1996); the daylength is calculated via Eq 1.6.11 in Duffie and Beckman (1991), using the sunset hour
angle (\eqn{h_{s}}{h_{s}}, Eq 8. in Davis et al. (2017)); finally, the mean hourly surface radiation is
derived as the quotient of the daily surface radiation and the daylength.}

\item{filename}{output filename}

\item{...}{additional arguments passed on to \code{\link[raster]{writeRaster}}}
}
\value{
A 12-layer RasterStack with one-year time series of monthly mean relative sunshine duration.
}
\description{
Estimates monthly averages for daily fraction of bright sunshine duration, for a given region and
    year, by using the monthly time series of temperature and precipitation, and the elevation data.
}
\details{
See \code{\link[macroBiome]{cliBrtSunDurFrcPoints}}.
}
\note{
The objects \code{'rs.temp'} and \code{'rs.prec'} must be 12-layer Raster* objects, while the object
    \code{'rl.elv'} has to be a single-layer Raster* object. These Raster* objects must have the same bounding
    box, projection, and resolution. The object \code{'sc.year'} has to be a single integer number.
}
\examples{
# Loading mandatory data for the Example 'Single-Year Grid'
data(inp_exSglyGrid)
inp_exSglyGrid <- lapply(inp_exSglyGrid, crop, extent(20.15, 20.25, 46.25, 46.35))

# Estimate values of the monthly mean relative sunshine duration
# at a grid cell near Szeged, Hungary (46.3N, 20.2E), in the year 2010
with(inp_exSglyGrid, {
rs.bsdf <- cliBrtSunDurFrcGrid(temp, prec, elv, sc.year = 2010)
rs.bsdf
})

}
\references{
\cite{Allen RG (1996) Assessing integrity of weather data for reference evapotranspiration estimation. J Irrig
    Drain Eng 122(2):97–106. \doi{10.1061/(ASCE)0733-9437(1996)122:2(97)}}

\cite{Berger A, Loutre MF (1991) Insolation values for the climate of the last 10 million years. Quat Sci Rev
    10(4):297-317. \doi{10.1016/0277-3791(91)90033-Q}}

\cite{Brock TD (1981) Calculating solar radiation for ecological studies. Ecol Model 14(1–2):1-19.
    \doi{10.1016/0304-3800(81)90011-9}}

\cite{Davis TW, Prentice IC, Stocker BD, Thomas RT, Whitley RJ, Wang H, Evans BJ, Gallego-Sala AV, Sykes MT,
    Cramer W (2017) Simple process-led algorithms for simulating habitats (SPLASH v.1.0): robust indices of
    radiation, evapotranspiration and plant-available moisture. Geosci Model Dev 10(2):689–708.
    \doi{10.5194/gmd-10-689-2017}}

\cite{Duffie JA, Beckman WA (1991) Solar Engineering of Thermal Processes. Second Edition. Wiley-Interscience,
    New York, NY}

\cite{Yin X (1997a) Calculating daytime mean relative air mass. Agric For Meteorol 87(2-3):85-90.
    \doi{10.1016/S0168-1923(97)00029-4}}

\cite{Yin X (1997b) Optical Air Mass: Daily Integration and its Applications. Meteorol Atmos Phys 63(3-4):227-233.
    \doi{10.1007/BF01027387}}

\cite{Yin X (1999) Bright Sunshine Duration in Relation to Precipitation, Air Temperature and Geographic Location.
    Theor Appl Climatol 64(1–2):61–68. \doi{10.1007/s007040050111}}
}
