% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mass_gis.R
\name{mass_gis}
\alias{mass_gis}
\alias{macleish_intersect}
\title{Retrieve elevation layers from MassGIS}
\source{
http://www.mass.gov/anf/research-and-tech/it-serv-and-support/application-serv/office-of-geographic-information-massgis/datalayers/layerlist.html
}
\usage{
mass_gis(layer = "contours250k")

macleish_intersect(x)
}
\arguments{
\item{layer}{MassGIS layer name to import}

\item{x}{an \code{\link[sf]{sf}} object}
}
\description{
Retrieve elevation layers from MassGIS
}
\details{
This function will download shapefiles from MassGIS, unzip them, 
transform the projection to EPSG:4326, compute their intersection with the
boundary of the MacLeish property, and return the resulting 
\code{\link[sf]{sf}} object.

Intersect a spatial layer with the MacLeish boundary layer
}
\examples{

\dontrun{
# have to download the shapefiles...could take a while...
elevation <- mass_gis()
macleish_elevation <- macleish_intersect(elevation)
if (require(sf)) {
  plot(macleish_elevation)
}

dcr_trails <- mass_gis("dcrtrails")

}
}
