% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mable-multivar.r
\name{dmixmvbeta}
\alias{dmixmvbeta}
\alias{pmixmvbeta}
\alias{rmixmvbeta}
\title{Multivariate Mixture Beta Distribution}
\usage{
dmixmvbeta(x, p, m, interval = NULL)

pmixmvbeta(x, p, m, interval = NULL)

rmixmvbeta(n, p, m, interval = NULL)
}
\arguments{
\item{x}{a matrix with \code{d} columns or a vector of length \code{d} within 
support hyperrectangle \eqn{[a, b] = [a_1, b_1] \times \cdots \times [a_d, b_d]}}

\item{p}{a vector of \code{K} values. All components of \code{p} must be 
nonnegative and sum to one for the mixture multivariate beta distribution. See 'Details'.}

\item{m}{a vector of degrees, \eqn{(m_1, \ldots, m_d)}}

\item{interval}{a vector of two endpoints or a \code{d x 2} matrix, each row containing 
the endpoints of support/truncation interval for each marginal density.
If missing, the i-th row is assigned as \code{c(min(x[,i]), max(x[,i]))}.}

\item{n}{sample size}
}
\description{
Density, distribution function,  and 
pseudorandom number generation for the multivariate Bernstein polynomial model, 
mixture of multivariate beta distributions, with given mixture proportions 
\eqn{p = (p_0, \ldots, p_{K-1})}, given degrees \eqn{m = (m_1, \ldots, m_d)},
 and support \code{interval}.
}
\details{
\code{dmixmvbeta()} returns a linear combination \eqn{f_m} of \eqn{d}-variate beta densities 
 on \eqn{[a, b]}, \eqn{\beta_{mj}(x) = \prod_{i=1}^d\beta_{m_i,j_i}[(x_i-a_i)/(b_i-a_i)]/(b_i-a_i)},   
 with coefficients \eqn{p(j_1, \ldots, j_d)}, \eqn{0 \le j_i \le m_i, i = 1, \ldots, d}, where
 \eqn{[a, b] = [a_1, b_1] \times \cdots \times [a_d, b_d]} is a hyperrectangle, and the  
 coefficients are arranged in the column-major order of \eqn{j = (j_1, \ldots, j_d)}, 
 \eqn{p_0, \ldots, p_{K-1}},  where \eqn{K = \prod_{i=1}^d (m_i+1)}. 
 \code{pmixmvbeta()} returns a linear combination \eqn{F_m} of the distribution
 functions of \eqn{d}-variate beta distribution.

 If all \eqn{p_i}'s are nonnegative and sum to one, then \code{p}
 are the mixture proportions of the mixture multivariate beta distribution.
}
