% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mable-dr.r
\name{dtmixbeta}
\alias{dtmixbeta}
\alias{ptmixbeta}
\alias{qtmixbeta}
\alias{rtmixbeta}
\title{Exponentially Tilted Mixture Beta Distribution}
\usage{
dtmixbeta(x, p, alpha, interval = c(0, 1), regr, ...)

ptmixbeta(x, p, alpha, interval = c(0, 1), regr, ...)

qtmixbeta(u, p, alpha, interval = c(0, 1), regr, ...)

rtmixbeta(n, p, alpha, interval = c(0, 1), regr, ...)
}
\arguments{
\item{x}{a vector of quantiles}

\item{p}{a vector of \code{m+1} components of \code{p} must be nonnegative 
and sum to one for mixture beta distribution. See 'Details'.}

\item{alpha}{regression coefficients}

\item{interval}{support/truncation interval \code{[a, b]}.}

\item{regr}{regressor vector function \eqn{r(x)=(1,r_1(x),...,r_d(x))} 
which returns n x (d+1) matrix, n=length(x)}

\item{...}{additional arguments to be passed to regr}

\item{u}{a vector of probabilities}

\item{n}{sample size}
}
\value{
A vector of \eqn{f_m(x; p)} or \eqn{F_m(x; p)} values at \eqn{x}.
\code{dmixbeta} returns the density, \code{pmixbeta} returns the cumulative
 distribution function, \code{qmixbeta} returns the quantile function, and
\code{rmixbeta}  generates pseudo random numbers.
}
\description{
Density, distribution function, quantile function and
pseudorandom number generation for the exponentially tilted  mixture of 
beta distributions, with shapes \eqn{(i+1, m-i+1)}, \eqn{i = 0, \ldots, m},  
given mixture proportions \eqn{p=(p_0,\ldots,p_m)} and support \code{interval}.
}
\details{
The density of the mixture exponentially tilted beta distribution on an 
 interval \eqn{[a, b]} can be written \eqn{f_m(x; p)=(b-a)^{-1}\exp(\alpha'r(x))
 \sum_{i=0}^m p_i\beta_{mi}[(x-a)/(b-a)]/(b-a)},
 where \eqn{p = (p_0, \ldots, p_m)}, \eqn{p_i\ge 0}, \eqn{\sum_{i=0}^m p_i=1} and
 \eqn{\beta_{mi}(u) = (m+1){m\choose i}u^i(1-x)^{m-i}}, \eqn{i = 0, 1, \ldots, m},
 is the beta density with shapes \eqn{(i+1, m-i+1)}. The cumulative distribution
function is \eqn{F_m(x; p) = \sum_{i=0}^m p_i B_{mi}[(x-a)/(b-a);alpha]}, where
\eqn{B_{mi}(u ;alpha)}, \eqn{i = 0, 1, \ldots, m}, is the exponentially tilted 
 beta cumulative distribution function with shapes \eqn{(i+1, m-i+1)}.
}
\examples{
# classical Bernstein polynomial approximation
a<--4; b<-4; m<-200
x<-seq(a,b,len=512)
u<-(0:m)/m
p<-dnorm(a+(b-a)*u)
plot(x, dnorm(x), type="l")
lines(x, (b-a)*dmixbeta(x, p, c(a, b))/(m+1), lty=2, col=2)
legend(a, dnorm(0), lty=1:2, col=1:2, c(expression(f(x)==phi(x)),
               expression(B^{f}*(x))))

}
\references{
Guan, Z., Application of Bernstein Polynomial Model to Density 
 and ROC Estimation in a Semiparametric Density Ratio Model
}
\seealso{
\code{\link{mable}}
}
\author{
Zhong Guan <zguan@iusb.edu>
}
\concept{Bernstein polynomial model}
\concept{Mixture beta distribution}
\keyword{distribution}
\keyword{models}
\keyword{nonparametric}
\keyword{smooth}
