% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mable.r
\name{dmixbeta}
\alias{dmixbeta}
\alias{pmixbeta}
\alias{qmixbeta}
\alias{rmixbeta}
\title{Mixture Beta Distribution}
\usage{
dmixbeta(x, p, interval = c(0, 1))

pmixbeta(x, p, interval = c(0, 1))

qmixbeta(u, p, interval = c(0, 1))

rmixbeta(n, p, interval = c(0, 1))
}
\arguments{
\item{x}{a vector of quantiles}

\item{p}{a vector of \code{m+1} values. The \code{m+1} components of \code{p}
must be nonnegative and sum to one for mixture beta distribution. See 'Details'.}

\item{interval}{support/truncation interval \code{[a, b]}.}

\item{u}{a vector of probabilities}

\item{n}{sample size}
}
\value{
A vector of \eqn{f_m(x; p)} or \eqn{F_m(x; p)} values at \eqn{x}.
\code{dmixbeta} returns the density, \code{pmixbeta} returns the cumulative
 distribution function, \code{qmixbeta} returns the quantile function, and
\code{rmixbeta}  generates pseudo random numbers.
}
\description{
Density, distribution function, quantile function and
pseudorandom number generation for the Bernstein polynomial model,
mixture of beta distributions, with shapes \eqn{(i+1, m-i+1)}, \eqn{i = 0, \ldots, m},
 given mixture proportions \eqn{p = (p_0, \ldots, p_m)} and support \code{interval}.
}
\details{
The density of the mixture beta distribution on an interval \eqn{[a, b]} can be written as a
 Bernstein polynomial \eqn{f_m(x; p) = \sum_{i=0}^m p_i\beta_{mi}[(x-a)/(b-a)]/(b-a)},
 where \eqn{p = (p_0, \ldots, p_m)}, \eqn{p_i\ge 0}, \eqn{\sum_{i=0}^m p_i=1} and
 \eqn{\beta_{mi}(u) = (m+1){m\choose i}u^i(1-x)^{m-i}}, \eqn{i = 0, 1, \ldots, m},
 is the beta density with shapes \eqn{(i+1, m-i+1)}. The cumulative distribution
function is \eqn{F_m(x; p) = \sum_{i=0}^m p_i B_{mi}[(x-a)/(b-a)]}, where
\eqn{B_{mi}(u)}, \eqn{i = 0, 1, \ldots, m}, is the beta cumulative distribution function
 with shapes \eqn{(i+1, m-i+1)}. If \eqn{\pi = \sum_{i=0}^m p_i<1}, then \eqn{f_m/\pi}
  is a truncated desity on \eqn{[a, b]} with cumulative distribution function
 \eqn{F_m/\pi}. The argument \code{p} may be any numeric vector of \code{m+1}
 values when \code{pmixbeta()} and and \code{qmixbeta()} return the integral
 function \eqn{F_m(x; p)} and its inverse, respectively, and \code{dmixbeta()}
 returns a Bernstein polynomial \eqn{f_m(x; p)}.
}
\examples{
# classical Bernstein polynomial approximation
a<--4; b<-4; m<-200
x<-seq(a,b,len=512)
u<-(0:m)/m
p<-dnorm(a+(b-a)*u)
plot(x, dnorm(x), type="l")
lines(x, (b-a)*dmixbeta(x, p, c(a, b))/(m+1), lty=2, col=2)
legend(a, dnorm(0), lty=1:2, col=1:2, c(expression(f(x)==phi(x)),
               expression(B^{f}*(x))))

}
\references{
Bernstein, S.N. (1912), Demonstration du theoreme de Weierstrass fondee sur le calcul des probabilities,
Communications of the Kharkov Mathematical Society, 13, 1–2.

Guan, Z. (2016) Efficient and robust density estimation using Bernstein type polynomials. \emph{Journal of Nonparametric Statistics}, 28(2):250-271.

Guan, Z. (2017) Bernstein polynomial model for grouped continuous data. \emph{Journal of Nonparametric Statistics}, 29(4):831-848.
}
\seealso{
\code{\link{mable}}
}
\author{
Zhong Guan <zguan@iusb.edu>
}
\concept{Bernstein polynomial model}
\concept{Mixture beta distribution}
\keyword{distribution}
\keyword{models}
\keyword{nonparametric}
\keyword{smooth}
