% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename.R
\name{rename}
\alias{rename}
\title{Rename variable}
\usage{
rename(data, old_var, new_var)
}
\arguments{
\item{data}{dataset}

\item{old_var}{name of existing variable}

\item{new_var}{new name to be changed}
}
\value{
\code{data.frame}
}
\description{
\code{rename()} changes names of variables.
}
\details{
\code{rename()} changes the name of an existing variable,
\code{var_old} to a new name, \code{var_new};
the contents of the variable are unchanged.

A group of variables can be also \code{renamed} by specifying the same
number of variables in both \code{var_old} and \code{var_new}
}
\examples{
## using infert dataset
data(infert)

# renaming one variable
infert.new <- rename(infert, age, AGE)
codebook(infert.new)

# renaming a group of variables
infert.new <- rename(infert,
                    c(age, parity, induced, case),
                    c(AGE, PARITY, INDUCED, CASE))
codebook(infert.new)


}
\author{
For any feedback, please contact \code{Myo Minn Oo} via:

Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
