% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flag.R
\name{flag}
\alias{flag}
\title{Criterion constructor function to be combined in a custom search statement}
\usage{
flag(name, negate = FALSE)
}
\arguments{
\item{name}{A string containing one or more flags to search for. Use
\href{#method-list_flags}{\code{ImapCon$list_flags()}} to list the flags
in a selected mail folder.}

\item{negate}{If \code{TRUE}, negates the search and seeks for "NOT SEARCH
CRITERIA". Default is \code{FALSE}.}
}
\description{
Criterion constructor function to be combined in a custom search statement
}
\examples{
\dontrun{
# select folder & search
con$select_folder(name = "INBOX")
# search for messages with Flag "UNSEEN" AND NOT Smaller Than  512KB.
res <- con$search(request = AND(flag("UNSEEN"),
                                smaller_than(size = 512000, negate = TRUE)))
}
}
\seealso{
Other custom search: 
\code{\link{AND}()},
\code{\link{ImapCon}},
\code{\link{OR}()},
\code{\link{before}()},
\code{\link{larger_than}()},
\code{\link{older_than}()},
\code{\link{on}()},
\code{\link{sent_before}()},
\code{\link{sent_on}()},
\code{\link{sent_since}()},
\code{\link{since}()},
\code{\link{smaller_than}()},
\code{\link{string}()},
\code{\link{younger_than}()}
}
\concept{custom search}
