% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configure_imap.R
\name{configure_imap}
\alias{configure_imap}
\title{IMAP Connection Configuration}
\usage{
configure_imap(
  url,
  username,
  password = NULL,
  xoauth2_bearer = NULL,
  use_ssl = TRUE,
  verbose = FALSE,
  buffersize = 16000,
  timeout_ms = 5000,
  ...
)
}
\arguments{
\item{url}{A character string containing the IMAP server address}

\item{username}{A character string containing the username.}

\item{password}{A character string containing the user's password.}

\item{xoauth2_bearer}{A character string containing the oauth2 bearer token.}

\item{use_ssl}{A logical indicating the use or not of Secure Sockets Layer
encryption when connecting to the IMAP server. Default is \code{TRUE}.}

\item{verbose}{If \code{FALSE}, mutes the flow of information between the
server and the client. Default is \code{FALSE}.}

\item{buffersize}{The size in bytes for the receive buffer. Default is
16000 bytes or 16kb, which means it will use the libcurl's default value.
According to the libcurl's documentation, the maximum buffersize is 512kb
(or 512000 bytes), but any number passed to \code{buffersize} is treated
as a request, not an order.}

\item{timeout_ms}{Time in milliseconds (ms) to wait for the execution or
re-execution of a command. Default is 5000ms (or 5 seconds). If a first
execution is frustrated, an error handler in each function (depending on
the \code{retries} value), will try to reconnect or re-execute the command.}

\item{...}{Further curl parameters (see \code{curl::curl_options}) that
can be used with the IMAP protocol. Only for advanced users.}
}
\value{
A new `ImapCon` object.
}
\description{
Configure and create a new IMAP connection.
}
