% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-attachments.R
\name{list_attachments}
\alias{list_attachments}
\title{List Attachments}
\usage{
list_attachments(msg_list)
}
\arguments{
\item{msg_list}{A \code{list} containing the full messages fetched from
the server after using \code{\link{fetch_full_msg}}.}
}
\value{
A \code{list} of \code{data.frames} containing filenames for each
    fetched message.
}
\description{
List attachments filenames after fetching full messages.
}
\examples{

\dontrun{

# configure IMAP
library(mRpostman)
imapconf <- configure_imap(url="imaps://your.imap.server.com",
                           username="your_username",
                           password=rstudioapi::askForPassword()
                          )

# listing attachments
attachments <- imapconf \%>\%
    select_mailbox(mbox = "TAM") \%>\%
    search_before(date_char = "10-may-2012", by = "UID") \%$\% #exposition pipe - two argg
    fetch_full_msg(imapconf = imapconf, msg_id = msg_id) \%>\%
    list_attachments()

}

}
\seealso{
Other attachments: \code{\link{get_attachments}}
}
\concept{attachments}
