% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracy_means.R
\name{mean_error_abs}
\alias{mean_error_abs}
\title{Mean absolute error}
\usage{
mean_error_abs(actual, predicted, na.rm = FALSE)
}
\arguments{
\item{actual}{A numeric vector with the actual values.}

\item{predicted}{A numeric vector with the predicted values. Each element in
this vector must be a prediction for the corresponding element in
\code{actual}.}

\item{na.rm}{A logical value indicating whether \code{NA} values should be
stripped before the computation proceeds. Defaults to \code{FALSE}.}
}
\value{
Returns a double scalar with the mean absolute error value.
}
\description{
Computes the average absolute error between the input vectors.
}
\examples{
actual <- runif(10)
predicted <- runif(10)

mean_error_abs(actual, predicted)
}
\seealso{
\code{\link[=mean_error]{mean_error()}},
\code{\link[=mean_error_pct]{mean_error_pct()}},
\code{\link[=mean_error_abs_pct]{mean_error_abs_pct()}},
\code{\link[=mean_error_sqr]{mean_error_sqr()}},
\code{\link[=mean_error_sqr_root]{mean_error_sqr_root()}}
}
