% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tz_lookup.R
\name{tz_lookup}
\alias{tz_lookup}
\title{Lookup time zones of sf or sp points}
\usage{
tz_lookup(x, crs = NULL, method = "fast", warn = TRUE)
}
\arguments{
\item{x}{either an \code{sfc} or \code{sf} points or \code{SpatialPoints(DataFrame)} object}

\item{crs}{the coordinate reference system: integer with the EPSG code, or character with proj4string.
If not specified (i.e., \code{NULL}) and \code{x} has no existing \code{crs}, EPSG: 4326 is assumed (lat/long).}

\item{method}{method by which to do the lookup. Either \code{"fast"} (default)
or \code{"accurate"}.}

\item{warn}{By default, if \code{method = "fast"} a warning is issued about
the potential for inaccurate results. Set \code{warn} to \code{FALSE} to turn
this off.}
}
\value{
character vector the same length as \code{x} specifying the time zone of the points.
}
\description{
There are two methods - \code{"fast"}, and \code{"accurate"}. The \code{"fast"} version can
look up many thousands of points very quickly, however  when a point is near
a time zone boundary and not near a populated centre, it may return the
incorrect timezone. If accuracy is more important than speed, use
\code{method = "accurate"}.
}
\examples{
if (require("sf")) {

state_pts <- lapply(seq_along(state.center$x), function(i) {
  st_point(c(state.center$x[i], state.center$y[i]))
})

state_centers_sf <- st_sf(st_sfc(state_pts))

state_centers_sf$tz <- tz_lookup(state_centers_sf)

plot(state_centers_sf[, "tz"])
}

}
