% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors-date.R
\name{date}
\alias{date}
\alias{date<-}
\title{Get/set date component of a date-time}
\usage{
date(x)

date(x) <- value
}
\arguments{
\item{x}{a date-time object}

\item{value}{an object for which the \code{date()} function is defined}
}
\value{
the date of x as a Date
}
\description{
Date-time must be a POSIXct, POSIXlt, Date, chron, yearmon, yearqtr, zoo,
zooreg, timeDate, xts, its, ti, jul, timeSeries, and fts objects.
}
\details{
\code{date()} does not yet support years before 0 C.E.
Also \code{date()} is not defined for Period objects.
}
\examples{
x <- as.POSIXct("2012-03-26 23:12:13", tz = "Etc/GMT+8")
date(x)
as.Date(x) # by default as.Date assumes you want to know the date in UTC
as.Date(x, tz = "Etc/GMT+8")
date(x) <- as.Date("2000-01-02")
x
}
\keyword{chron}
\keyword{manip}
\keyword{methods}
\keyword{utilities}
