% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors-week.r
\name{week}
\alias{isoweek}
\alias{week}
\alias{week<-}
\title{Get/set weeks component of a date-time.}
\usage{
week(x)

week(x) <- value

isoweek(x)
}
\arguments{
\item{x}{a date-time object. Must be a POSIXct, POSIXlt, Date, chron,
yearmon, yearqtr, zoo, zooreg, timeDate, xts, its, ti, jul, timeSeries, or
fts object.}

\item{value}{a numeric object}
}
\value{
the weeks element of x as an integer number
}
\description{
\code{week} returns the number of complete seven day periods that have
occured between the date and January 1st, plus one.\cr
\code{isoweek} returns the week as it would appear in the ISO 8601 system,
which uses a reoccuring leap week.
}
\examples{
x <- ymd("2012-03-26")
week(x)
week(x) <- 1
week(x) <- 54
week(x) > 3
}
\references{
\url{http://en.wikipedia.org/wiki/ISO_week_date}
}
\seealso{
\code{\link{isoyear}}
}
\keyword{chron}
\keyword{manip}
\keyword{utilities}

