"grm" <-
function (data, constrained = FALSE, IRT.param = TRUE, Hessian = FALSE, start.val = NULL, na.action = na.omit, 
                 control = list()) {
    cl <- match.call()
    if ((!is.data.frame(data) & !is.matrix(data)) || ncol(data) == 1)
        stop("'data' must be either a numeric matrix or a data.frame, with at least two columns.\n")
    X <- data.matrix(data)    
    X <- na.action(X)
    colnamsX <- colnames(X)
    dimnames(X) <- NULL
    ncatg <- apply(X, 2, function (x) length(unique(x)))
    if (any(ind <- ncatg <= 2))
        stop("Items: ", paste(which(ind), collapse = ", "), ", appear to have 2 or less levels.\n")
    n <- nrow(X)
    p <- ncol(X)
    pats <- apply(X, 1, paste, collapse = "")
    freqs <- table(pats)
    nfreqs <- length(freqs)
    obs <- as.vector(freqs)
    X <- apply(cbind(names(freqs)), 1, function (x) { nx <- nchar(x); substring(x, 1:nx, 1:nx) } )
    X <- as.numeric(t(X))
    dim(X) <- c(nfreqs, p)
    con <- list(iter.qN = 150, GHk = 15, method = "BFGS", verbose = FALSE, digits.abbrv = 6)
    con[names(control)] <- control
    GH <- GHpoints(data ~ z1, con$GHk)
    Z <- GH$x[, 2]
    GHw <- GH$w
    ind1 <- if (constrained) c(1, cumsum(ncatg[-p] - 1) + 1) else c(1, cumsum(ncatg[-p]) + 1)
    ind2 <- if (constrained) cumsum(ncatg - 1) else cumsum(ncatg)
    betas <- start.val.grm(start.val, X, obs, constrained, ncatg)
    environment(loglikgrm) <- environment(scoregrm) <- environment()
    old <- options(warn = (-1))
    on.exit(options(old))
    res.qN <- optim(unlist(betas), fn = loglikgrm, gr = scoregrm, method = con$method, hessian = Hessian, 
                    control = list(maxit = con$iter.qN, trace = as.numeric(con$verbose)), constrained = constrained)
    if (Hessian) {
        ev <- eigen(res.qN$hes, TRUE, TRUE)$values
        if (!all(ev >= -1e-06 * abs(ev[1]))) 
            warning("Hessian matrix at convergence is not positive definite, unstable solution; re-fit the model using start.val = 'random'.\n")
    }
    if (sign(res.qN$par[ind2[1]]) == -1)
        res.qN$par[ind2] <- - res.qN$par[ind2]
    betas <- betas.grm(res.qN$par, constrained, ind1, ind2, p)
    names(betas) <- if (!is.null(colnamsX)) colnamsX else paste("Item", 1:p)
    betas <- lapply(betas, function (x) { names(x) <- c(paste("beta.", seq(1, length(x) - 1), sep = ""), "beta"); x } )
    max.sc <- max(abs(scoregrm(res.qN$par, constrained)))
    fit <- list(coefficients = betas, log.Lik = -res.qN$val, convergence = res.qN$conv, hessian = res.qN$hes, 
                counts = res.qN$counts, patterns = list(X = X, obs = obs), GH = list(Z = Z, GHw = GHw), max.sc = max.sc, 
                constrained = constrained, IRT.param = IRT.param, X = data, control = con, na.action = na.action,
                call = cl)
    class(fit) <- "grm"
    fit
}

