% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intrm1pl_normal_mcar.R
\name{intrm1pl_normal_mcar}
\alias{intrm1pl_normal_mcar}
\title{1pl LSIRM model with normal likelihood using multiplicative effect for missing completely at random data.}
\usage{
intrm1pl_normal_mcar(
  data,
  ndim = 2,
  niter = 15000,
  nburn = 2500,
  nthin = 5,
  nprint = 500,
  jump_beta = 0.4,
  jump_theta = 1,
  jump_delta = 1,
  pr_mean_beta = 0,
  pr_sd_beta = 1,
  pr_mean_theta = 0,
  pr_mean_delta = 0,
  pr_sd_delta = 1,
  pr_a_theta = 0.001,
  pr_b_theta = 0.001,
  pr_a_eps = 0.001,
  pr_b_eps = 0.001,
  missing = 99
)
}
\arguments{
\item{data}{Matrix; binary item response matrix to be analyzed. Each row is assumed to be respondent and its column values are assumed to be response to the corresponding item.}

\item{ndim}{Numeric; dimension of latent space. default value is 2.}

\item{niter}{Numeric; number of iterations to run MCMC sampling. default value is 15000.}

\item{nburn}{Numeric; number of initial, pre-thinning, MCMC iterations to discard. default value is 2500.}

\item{nthin}{Numeric;number of thinning, MCMC iterations to discard. default value is 5.}

\item{nprint}{Numeric; MCMC samples is displayed during execution of MCMC chain for each \code{nprint}. default value is 500.}

\item{jump_beta}{Numeric; jumping rule of the proposal density for beta. default value is 0.4.}

\item{jump_theta}{Numeric; jumping rule of the proposal density for theta. default value is 1.0.}

\item{jump_delta}{Numeric; jumping rule of the proposal density for delta default value is 1.0.}

\item{pr_mean_beta}{Numeric; mean of normal prior for beta. default value is 0.}

\item{pr_sd_beta}{Numeric; standard deviation of normal prior for beta. default value is 1.0.}

\item{pr_mean_theta}{Numeric; mean of normal prior for theta. default value is 0.}

\item{pr_mean_delta}{Numeric; mean of normal prior for delta. default value is 0.}

\item{pr_sd_delta}{Numeric; standard deviation of normal prior for delta. default value is 1.0.}

\item{pr_a_theta}{Numeric; shape parameter of inverse gamma prior for variance of theta. default value is 0.001.}

\item{pr_b_theta}{Numeric; scale parameter of inverse gamma prior for variance of theta. default value is 0.001.}

\item{pr_a_eps}{Numeric; shape parameter of inverse gamma prior for variance of data likelihood. default value is 0.001.}

\item{pr_b_eps}{Numeric; scale parameter of inverse gamma prior for variance of data likelihood default value is 0.001.}

\item{missing}{Numeric; a number to replace missing values. default value is 99.}
}
\value{
\code{intrm1pl_normal_mcar} returns an object of  list containing the following components:
 \item{beta_estimate}{posterior estimation of beta.}
 \item{theta_estimate}{posterior estimation of theta.}
 \item{sigma_theta_estimate}{posterior estimation of standard deviation of theta.}
 \item{sigma_estimate}{posterior estimation of standard deviation.}
 \item{delta_estimate}{posterior estimation of delta.}
 \item{beta}{posterior samples of beta.}
 \item{theta}{posterior samples of theta.}
 \item{theta_sd}{posterior samples of standard deviation of theta.}
 \item{sigma}{posterior samples of standard deviation.}
 \item{delta}{posterior samples of delta.}
 \item{accept_beta}{accept ratio of beta.}
 \item{accept_theta}{accept ratio of theta.}
 \item{ls_mean_item}{posterior estimation of latent position of item.}
 \item{ls_mean_respondent}{posterior estimation of latent position of respondent.}
 \item{ls_mean_lambda}{posterior estimation lambda. The  singular value of the decomposition.}
 \item{ls_respondent}{posterior samples of latent positon of respondent.}
 \item{ls_item}{posterior samples of latent positon of item.}
 \item{ls_lambda}{posterior samples of lambda which is singular value of decomposition.}
}
\description{
\link{intrm1pl_normal_mcar} is used to fit LSIRM model for continuous variable with 1pl using multiplicative effect in incomplete data under missing completely at random assumption.

\link{intrm1pl_normal_mcar} factorizes continuous item response matrix into column-wise item effect, row-wise respondent effect and further embeds multiplicative effect in a latent space, while ignoring the missing element under the assumption of missing completely at random. The resulting latent space provides an interaction map that represents interactions between respondents and items.
}
\details{
\code{intrm1pl_normal_mcar} models the continuous value of response by respondent \eqn{j} to item \eqn{i} with item effect \eqn{\beta_i}, respondent effect \eqn{\theta_j} in the shared metric space: \deqn{Y_{j,i} = \theta_j+\beta_i+\delta_{j,i} + e_{j,i}} where the error \eqn{e_{j,i} \sim N(0,\sigma^2)}. The final latent positions of respondents and items are the singular vectors of matrix with its \eqn{j,i} element \eqn{\delta_{j,i}}. Under the assumption of missing completely at random, the model ignores the missing element in doing inference. For the details of missing completely at random assumption and data augmentation, see References.
}
\examples{
# generate example (continuous) item response matrix
data     <- matrix(rnorm(500, mean = 0, sd = 1),ncol=10,nrow=50)

# generate example missing indicator matrix
missing_mat     <- matrix(rbinom(500, size = 1, prob = 0.2),ncol=10,nrow=50)

# make missing value with missing indicator matrix
data[missing_mat==1] <- 99 

lsirm_result <- intrm1pl_normal_mcar(data)

# The code following can achieve the same result.
lsirm_result <- intrm1pl_normal(data, missing_data = 'mcar')

}
\references{
Little, R. J., & Rubin, D. B. (2019). Statistical analysis with missing data (Vol. 793). John Wiley & Sons.
}
